<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

$config['table'] = array(
			array(
				'field'   => 'image',
				'label'   => lang('field_image')
			),
			array(
				'field'   => 'fullname',
				'label'   => lang('field_name')
			),
			array(
				'field'   => 'user',
				'label'   => lang('field_user')
			),
			array(
				'field'   => 'business_partner',
				'label'   => lang('field_business_partner')
			),
			array(
				'field'   => 'id',
				'label'   => lang('actions')
			)
		);
		
$config['create'] = array(
			'fullname' => array(
				'field' => 'fullname',
				'label' => lang('field_fullname'),
				'rules' => ''
			),
			'user_role' => array(
				'field' => 'user_role',
				'label' => lang('field_user_role'),
				'type'  => "hidden",
				'value' => 2
			),
			'business_partner' => array(
				'field' => 'business_partner',
				'label' => lang('field_business_partner'),
				'rules' => 'required',
				'type'	=> 'select',
				'model'	=> 'managers_m',
				'method' => 'get_business_partnerlist',
			),
			'image' => array(
				'field' => 'image',
				'label' => lang('field_image'),
				'type'  => "file",
				'filetype' => 'image',
				'dir'   => 'avatar',
				'rules' => 'required'
			),
			'user' => array(
				'field' => 'user',
				'label' => lang('field_user'),
				'rules' => 'required|is_unique[admin.user]'
			),
			'password' => array(
				'field' => 'password',
				'label' => lang('field_password'),
				'type'  => "password"
			),
			'company' => array(
				'field' => 'company',
				'label' => lang('field_company'),
				'rules' => ''
			),
			'language' => array(
				'field' => 'language_id',
				'label' => lang('field_language'),
				'type' => 'select',
				'rules' => 'required',
				'model' => 'languages_m',
				'method' => 'get_languages',
			),
		);
		
$config['edit'] = $config['create'];
unset($config['edit']['user']);
