<?php
 /**
  * Controller for Admin
  *
  * This is the controller used to Admin section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Admin - Controller
  *
  * Controller for Admin section.
  */
class Admin extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'admin_m';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->create_title	= lang('admin_create');
		$this->icon			= 'fa fa-user-secret';
		$this->main_tip		= lang('admin_tip');
		$this->main_title	= lang('menu_admin');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table(anchor('admin/create','<i class="fa fa-plus"></i> '.lang('admin_create'), 'class="btn btn-primary btn-sm"'));
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column
	  * @param mixed $value Value
	  * @param array $row Array containing all row data
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$row)
	{
		switch($key)
		{
			case 'main_manager':
				$value				= $value == 1 ? lang('yes') : lang('no');
				break;
			case 'image':
				$value				= '<img src="'.site_url('uploader/view/avatar'.$value).'" style="display:block; margin:0 auto; border-radius: 50%; width: 50px; height: 50px;" alt="User Image">';
				break;
			case 'id':
				$id					= $value;

				$value				= anchor('admin/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
				$value				.= "&nbsp;";
				$value				.= anchor('admin/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');
				break;
		}

		return $value === NULL? '' : $value;
	}
}