<?php
 /**
  * Controller for Checklogin
  *
  * This is the controller used to Checklogin section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Checklogin - Controller
  *
  * Controller for Checklogin.
  */
class Checklogin extends CI_Controller 
{
	/**
	  * Constructor
	  */
	function __construct()
	{	
		parent::__construct();
	}

	/**
	  * Return a JSON with success if actual session is logged
	  *
	  * @ return string
	  */
	function index()
	{
		$this->load->model('login_m');

		$success		= false;
		if($this->login_m->is_loged_in())
		{
			$success		= true;
		}
		
		$this->output->set_content_type('application/json')
        	->set_output(json_encode(array('success' => $success)));
	}
}