<?php
 /**
  * Controller for Clients
  *
  * This is the controller used to Clients section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients - Controller
  *
  * Controller for Clients section.
  */
class Clients extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model			= 'clients_m';
	/** @var string This is the edit message to the section. */
	var $edit_view 		= 'clients/edit';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->icon			= 'fa fa-smile-o';
		$this->main_tip		= lang('clients_tip');
		$this->main_title	= lang('menu_clients');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table();
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column
	  * @param mixed $value Value
	  * @param array $row Array containing all row data
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$row)
	{
		switch($key)
		{
			case 'id':
				$id					= $value;
				$value				= '<a href="clients_repo/index/'.$id.'" id="document-'.$id.'" data-value="'.$id.'" class="btn btn-success btn-sm"><i class="fa fa-book"></i>'.lang('docs').'</a>';
				break;
			case 'isinvoice':
				if($value == '1')
				{
					$value				= '<input type="checkbox" onchange="invoicechecked('.$row->id.',1);" checked="true" name="isinvoice" id="isinvoice-'.$row->id.'" />';
				} else {
					$value				= '<input type="checkbox" onchange="invoicechecked('.$row->id.',0);" name="isinvoice" id="isinvoice-'.$row->id.'" />';
				}
				break;
		}

		return $value === NULL ? '' : $value;
	}

	/**
	  * Return layout view for invoice section.
	  */
	function invoice()
	{
		$this->load->model('clients_m');

		$id					= $this->input->post('client_id');
		$isinvoice			= $this->clients_m->checkclientinvoice($id);

		if($isinvoice > 0)
		{
			$data['description'] = "Are you sure you need to delete it?";
		} else {
			$data['description'] = "Are you sure you need to create it?";
		}
		$data['clientid']	= $id;

		$this->load->view('clients/invoice-model',$data);
	}

	/**
	  * Make invoice for specified client.
	  *
	  * @param int $client_id Client ID
	  */
	function clickedinvoice($client_id)
	{
		$this->load->model('clients_m');

		$this->clients_m->clientinvoice($client_id);

		return $id;
	}

	/**
	  * This callback runs on query for table of the crud.
	  * Use to add where clause on the query
	  *
	  */
	function _callback_filter()
	{
		$current_user		= $this->login_m->get_user();

		if($current_user['user_role'] == "2")
			return "partner_id = '".$current_user['business_partner']."'";

		return "";
	}

	/**
	  * Load crud table view
	  *
	  * @param string $toolbar HTML buttons to inject on toolbar box
	  * @param string $items_key Key to read off config
	  */
	public function _table($toolbar='', $items_key='table')
	{
		$name				= strtolower(get_class($this));
		$items_table		= $this->_get_items($items_key);

		$current_user		= $this->login_m->get_user();

		if($current_user['user_role'] == "2")
		{
			unset(
				$items_table[3]
			);
		}

		$this->show_template('crud/table', [
			'table_id'			=> $name."_table",
			'toolbar'			=> $toolbar,
			'items_source'		=> $name.'/table',
			'items_table'		=> $items_table
		]);
	}

	/**
	  * Return JSON to table crud
	  *
	  * @param string $items_key Key to read off config
	  */
	function _ajax_table($items_key = 'table')
	{
		$model				= $this->model;
		if(empty($model))
		{
			return FALSE;
		}

		$items_table		= $this->_get_items($items_key);

		$current_user		= $this->login_m->get_user();

		if($current_user['user_role'] == "2")
		{
			unset(
				$items_table[3]
			);
		}

		/*
		 * Paging
		 */
		$sOffset			= 0;
		$sPagesize			= 0;
		if(isset($_POST['iDisplayStart']) && $_POST['iDisplayLength'] != '-1')
		{
			$sOffset			= $_POST['iDisplayStart'];
			$sPagesize			= $_POST['iDisplayLength'];
		}

		/*
		 * Ordering
		 */
		$sOrder				= array();
		if(isset($_POST['iSortCol_0']))
		{
			for($i = 0; $i < intval($_POST['iSortingCols']); $i++)
			{
				if($_POST['bSortable_'.intval($_POST['iSortCol_'.$i])] == "true")
				{
					$value				= $_POST['sSortDir_'.$i];
					$index				= intval( $_POST['iSortCol_'.$i] );
					$name				= $items_table[$index];
					if(isset($name['alias']))
					{
						$sOrder[$name['alias']] = $value;
					} else {
						$sOrder[$name['field']] = $value;
					}

				}
			}
		}

		/*
		 * Filtering
		 * NOTE this does not match the built-in DataTables filtering which does it
		 * word by word on any field. It's possible to do here, but concerned about efficiency
		 * on very large tables, and MySQL's regex functionality is very limited
		 */
		$sLikeOR			= array();
		if(isset($_POST['sSearch']))
		{
			$SearchString		= $_POST['sSearch'];
		} else {
			$SearchString		= "";
		}
		if($SearchString != "")
		{
			foreach($items_table as $item_table)
			{
				if(!isset($item_table['search']) || $item_table['search'] !== FALSE)
				{
					$sLikeOR[$item_table['field']] = $SearchString;
				}
			}
		}

		$filter				= $this->_callback_filter();

		$TotalRecords		= $this->$model->read_table($items_table, array(), array(), 0, 0, TRUE, $filter);
		$DisplayRecords		= $this->$model->read_table($items_table, $sLikeOR, array(), 0, 0, TRUE, $filter);
		$data_table			= $this->$model->read_table($items_table, $sLikeOR, $sOrder, $sPagesize, $sOffset, FALSE, $filter);

		$aaData				= [];
		foreach($data_table as $rows)
		{
			if(method_exists($this, "_callback_previous_row"))
			{
				$this->_callback_previous_row($rows);
			}

			$row				= [];
			foreach($rows as $key => $item)
			{
				$ret_row			= $this->_callback_row($key, $item, $rows);
				if($ret_row !== NULL)
				{
					$row[]				= $ret_row;
				}
			}
			$aaData[]			= $row;
		}

		return [
			'sEcho'					=> intval($this->input->post('sEcho')),
			'iTotalRecords'			=> $TotalRecords,
			'iTotalDisplayRecords'	=> $DisplayRecords,
			'aaData'				=> $aaData
		];
	}
}