<?php
 /**
  * Controller for Login
  *
  * This is the controller used to Login section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Login - Controller
  *
  * Controller for Login section.
  */
class Login extends MY_Controller
{
	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * Do login from get or post
	  */
	function index()
	{
		if($this->input->get('user') && $this->input->get('password'))
		{
			$user_id			= $this->login_m->login($this->input->get('user'), $this->input->get('password'));
			if(is_null($user_id))
			{
				log_message('error', 'Login incorrect '.$this->input->get('user').":".$this->input->get('password'));
				$this->form_validation->set_message('_check_login', lang('login_incorrect'));
			}

			$this->_do_login();
		}

		$this->form_validation->set_rules('user', lang('username'), 'callback__check_login');

		$this->_do_login();

		if($this->form_validation->run() == false)
		{
			$this->load->view('templates/login', [
				'login_text'			=> $this->config->item('login_text'),
				'version'				=> $this->version
			]);
		} else {
			$this->_do_login();
		}
	}

	/**
	  * Do logout
	  */
	function logout()
	{
		$this->login_m->logout();

		redirect('login');
	}

	/**
	  * Helper to login to check user & password
	  *
	  * @param string $user User
	  *
	  * @return true|false
	  */
	function _check_login($user)
	{
		$user_id			= $this->login_m->login($user, $this->input->post('password'));
		if (!is_null($user_id))
		{
			return true;
		} else {
			log_message('error', 'Login incorrect '.$user.":".$this->input->post('password'));
			$this->form_validation->set_message('_check_login', lang('login_incorrect'));

			return false;
		}
	}

	/**
	  * Check if is logged to redirect to home
	  */
	function _do_login()
	{
		if($this->login_m->is_loged_in())
		{
			redirect('/');
		}
	}
}