<?php
 /**
  * Controller for Clients Categories
  *
  * This is the controller used to Clients Categories section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients_categories - Controller
  *
  * Controller for Clients Categories section.
  */
class Clients_categories extends MY_Controller {

	var $model = 'clients_categories_m';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->create_title	= lang('repo_categories_create');
		$this->icon			= 'fa fa-folder-o';
	}

	/**
	  * Return layout view for create section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int|null $parent_id Parent ID
	  */
	function create($client_id, $parent_id=NULL)
	{
		$this->clients_categories_m->set_parent_id($parent_id);
		$this->clients_categories_m->set_client_id($client_id);

		$parent_id			= $parent_id==NULL ? 'root' : 'c_'.$parent_id;
		$data				= $this->_create('clients_repo/tree_panel/'.$client_id.'/'.$parent_id, '#clients_repo_tree_content');

		$this->load->view('crud/create', $data);
	}

	/**
	  * Return layout view for edit section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int $id ID
	  */
	function edit($client_id, $id)
	{
		$back				= 'clients_repo/tree_panel/'.$client_id.'/c_'.$id;

		$this->load->view('crud/edit', $this->_edit($id, $back, '#clients_repo_tree_content'));
	}

	/**
	  * Return layout view for delete section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int $id ID
	  */
	function delete($client_id, $id)
	{
		$cat				= $this->clients_categories_m->get_one($id);
		$cat_id				= $cat['parent_id']==NULL ? 'root' : 'c_'.$cat['parent_id'];
		$back				= 'clients_repo/tree_panel/'.$client_id.'/c_'.$id;
		$ok					= 'clients_repo/tree_panel/'.$client_id.'/'.$cat_id;

		$this->load->view('crud/delete', $this->_delete($id, $back, '#clients_repo_tree_content', $ok, FALSE));
	}
}