<?php
 /**
  * Controller for Clients Docs
  *
  * This is the controller used to Clients Docs section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients_docs - Controller
  *
  * Controller for Clients Docs section.
  */
class Clients_docs extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'clients_docs_m';

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();

		$this->create_title	= lang('repo_docs_create');
		$this->icon			= 'fa fa-file-o';
	}

	/**
	  * Return layout view for create section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int|null $parent_id Parent ID
	  */
	function create($client_id, $parent_id=NULL)
	{
		$this->clients_docs_m->set_category_id($parent_id);
		$this->clients_docs_m->set_client_id($client_id);

		$parent_id			= $parent_id==NULL ? 'root' : 'c_'.$parent_id;
		$back				= 'clients_repo/tree_panel/'.$client_id.'/'.$parent_id;

		$this->load->view('crud/create', $this->_create($back, '#clients_repo_tree_content'));
	}

	/**
	  * Return layout view for edit section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int $id ID
	  */
	function edit($client_id, $id)
	{
		$back				= 'clients_repo/tree_panel/'.$client_id.'/d_'.$id;

		$this->load->view('crud/edit', $this->_edit($id, $back, '#clients_repo_tree_content'));
	}

	/**
	  * Return layout view for delete section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int $id ID
	  */
	function delete($client_id, $id)
	{
		$doc				= $this->clients_docs_m->get_one($id);
		$cat_id				= $doc['category_id']==NULL ? 'root' : 'c_'.$doc['category_id'];
		$back				= 'clients_repo/tree_panel/'.$client_id.'/d_'.$id;
		$ok					= 'clients_repo/tree_panel/'.$client_id.'/'.$cat_id;

		$this->load->view('crud/delete', $this->_delete($id, $back, '#clients_repo_tree_content', $ok, FALSE));
	}
}