<?php 
 /**
  * Controller for Clients notifications
  *
  * This is the controller used to Clients notifications section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients_notifications - Controller
  *
  * Controller for Clients notifications section.
  */
class Clients_notifications extends MY_Controller {

	var $model = 'notifications_clients_m';
	var $client_id;

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = '';
		$this->main_tip = lang('clients_tip');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index($client_id)
	{
		$this->load->model('clients_m');

		$client				= $this->clients_m->get_one($client_id);
		$this->main_title	= $client['name'].' '.$client['surname'];

		$this->add_pre_breadcum('clients', '<i class="fa fa-smile-o"></i> '. lang('menu_clients'));

		$name				= strtolower(get_class($this));

		$this->show_template('clients_notifications/table', [
			'values'			=> $client,
			'table_id'			=> $name."_table",
			'toolbar'			=> '',
			'items_source'		=> $name.'/table/'.$client_id,
			'items_table'		=> $this->_get_items('table')
		]);
	}
	
	public function table($client_id)
	{
		$this->client_id = $client_id;
		$this->load->view('output/json', array('json' => $this->_ajax_table()));
	}
	
	function view($id)
	{
		$this->load->model('notifications_m');
		$notification = $this->notifications_m->get_one($id);
		$content = $notification['description'];
		$data['dialog_icon'] = "fa fa-bullhorn";
		$data['dialog_tittle'] = $notification['title'];
		$data['dialog_title_background'] = "bg-green";
		$data['dialog_content'] = $content;
		$extra = $this->load->view('items/dialog_content', $data);
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column 
	  * @param mixed $value Value 
	  * @param array $row Array containing all row data 
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$row)
	{
		switch($key)
		{
			case 'id':
				$value				= anchor('#','<i class="fa fa-search"></i> '.lang('notification_view'), 'class="btn btn-success btn-sm" data-toggle="modal" data-target="#dialog_modal" data-href="'.site_url('clients_notifications/view/'.$value).'"');
				break;
		}

		return $value === NULL ? '' : $value; 
	}

	/**
	  * This callback runs on query for table of the crud.
	  * Use to add where clause on the query
	  *
	  */
	function _callback_filter()
	{
		return "client_id=".$this->client_id;
	}
	
}