<?php
 /**
  * Controller for Clients repo docs
  *
  * This is the controller used to Clients repo docs section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients_repo_docs - Controller
  *
  * Controller for Clients repo docs section.
  */
class Clients_repo_docs extends MY_Controller {

	var $model = 'clients_repo_docs_m';

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-book';
		$this->main_title = '';
		$this->main_tip = lang('clients_repo_docs_tip');
	}

	public function _tree($content = NULL, $client_id)
	{
		$name = strtolower(get_class($this));
		$data = array();
		$data['tree_id'] = $name."_tree";
		$this->load->model('clients_m');
		$data['values'] = $this->clients_m->get_one($client_id);
		$data['tree_source'] = $name."/tree_source/".$client_id;
		$data['tree_panel'] = $name."/tree_panel/".$client_id;
		$data['tree_content'] = $content;
		$this->show_template('clients_repo_docs/tree', $data);
	}

	function index($client_id)
	{
		$this->load->model('clients_m');
		$client = $this->clients_m->get_one($client_id);
		$this->main_title = $client['name'].' '.$client['surname'];
		$this->add_pre_breadcum('clients', '<i class="fa fa-smile-o"></i> '. lang('menu_clients'));
		$this->_tree($this->tree_panel($client_id), $client_id);
	}

	function tree_source($client_id)
	{
		$this->load->model('clients_repo_docs_m');
		$this->load->model('docs_assignment_repo_docs_m');
		$this->load->model('repo_docs_m');

		$clients_docs		= $this->clients_repo_docs_m->get_ids_by_client_id($client_id);
		$assigments_docs	= $this->docs_assignment_repo_docs_m->get_ids_by_client_id($client_id);

		$docs_ids			= array_merge($clients_docs, $assigments_docs);
		$cats_ids			= array();
		foreach($docs_ids as $doc_id){
			$cats = $this->repo_docs_m->get_cats_branch($doc_id);
			foreach($cats as $cat_id){
				if(!in_array($cat_id, $cats_ids)){
					$cats_ids[] = $cat_id;
				}
			}
		}

		$id = $this->input->post('id');
		$data = array();
		if($id=='#'){
			$data[] =  array('id' => 'root',
						'children' => TRUE,
						'text' => lang('repo_root'),
						'icon' => 'fa fa-book',
						'state' => array('opened' => TRUE)
					);
		}
		if($id=='root'){
			$this->load->model('repo_categories_m');
			$cats = $this->repo_categories_m->get_by_parent(null);
			foreach($cats as $cat){
				$tree_cat = array('id' => 'c_'.$cat['id'],
								'children' => TRUE,
								'icon' => 'fa fa-folder-open-o',
								'text' => $cat['category_name']);
				if(in_array($cat['id'], $cats_ids)){
					$tree_cat['li_attr'] = array('style' => 'color:green');
				}else{
					$tree_cat['li_attr'] = array('style' => 'color:black');
				}
				$data[] = $tree_cat;
			}
			$this->load->model('repo_docs_m');
			$docs = $this->repo_docs_m->get_by_category_id(null);
			foreach($docs as $doc){
				$tree_doc = array('id' => 'd_'.$doc['id'],
								'children' => FALSE,
								'icon' => 'fa fa-file-o',
								'text' => $doc['name']);
				if(in_array($doc['id'], $docs_ids)){
					$tree_doc['li_attr'] = array('style' => 'color:green');
				}else{
					$tree_doc['li_attr'] = array('style' => 'color:black');
				}
				$data[] = $tree_doc;
			}
		}
		if(substr($id, 0, 2)=='c_'){
			$id = str_replace('c_', '', $id);
			$this->load->model('repo_categories_m');
			$cats = $this->repo_categories_m->get_by_parent($id);
			foreach($cats as $cat){
				$tree_cat = array('id' => 'c_'.$cat['id'],
								'children' => TRUE,
								'icon' => 'fa fa-folder-open-o',
								'text' => $cat['category_name']);
				if(in_array($cat['id'], $cats_ids)){
					$tree_cat['li_attr'] = array('style' => 'color:green');
				}else{
					$tree_cat['li_attr'] = array('style' => 'color:black');
				}
				$data[] = $tree_cat;
			}
			$this->load->model('repo_docs_m');
			$docs = $this->repo_docs_m->get_by_category_id($id);
			foreach($docs as $doc){
				$tree_doc = array('id' => 'd_'.$doc['id'],
								'children' => FALSE,
								'icon' => 'fa fa-file-o',
								'text' => $doc['name']);
				if(in_array($doc['id'], $docs_ids)){
					$tree_doc['li_attr'] = array('style' => 'color:green');
				}else{
					$tree_doc['li_attr'] = array('style' => 'color:black');
				}
				$data[] = $tree_doc;
			}
		}

		$this->load->view('output/json', array('json' =>$data));
	}

	function tree_panel($client_id, $id = NULL)
	{
		if($id==NULL){
			$refresh = FALSE;
			$id = $this->input->post('id');
		}else{
			$refresh = TRUE;
		}
		$item_tree_id = $id;
		$data = array();
		if(!$id){
			$data = $this->_panel_welcome();
			return $this->load->view('items/box', $data, TRUE);
		}elseif($id=='root'){
			$data = $this->_panel_root();
		}else{
			switch (substr($id, 0, 2)) {
				case 'c_':
					$id = str_replace('c_', '', $id);
					$data = $this->_panel_category($id);
					break;
				case 'd_':
					$id = str_replace('d_', '', $id);
					$data = $this->_panel_document($client_id, $id);
					break;
			}
		}
		$this->load->view('items/box', $data);
		if($refresh){
			$this->load->view('crud/tree_refresh', array('tree_id' => '#clients_repo_docs_tree', 'id' => $item_tree_id));
		}
	}

	function _panel_welcome()
	{
		$data = array();
		$data['box_icon'] = "fa fa-book";
		$data['box_title'] = lang('repo_select');
		$data['box_content'] = $this->load->view('repo/welcome', NULL, TRUE);
		return $data;
	}

	function _panel_root()
	{
		$data = array();
		$data['box_icon'] = "fa fa-book";
		$data['box_title'] = lzng('repo_root');
		$data['box_content'] = $this->load->view('repo/root', NULL, TRUE);
		return $data;
	}

	function _panel_category($id)
	{
		$this->load->model('repo_categories_m');
		$cat = $this->repo_categories_m->get_custom_one($id);
		if(empty($cat)){show_404();}
		$data = array();
		$data['box_icon'] = "fa fa-folder-o";
		$data['box_title'] =lang('category')." ".$cat['category_name'];
		$data['box_content'] = $this->load->view('repo/category', $cat, TRUE);
		return $data;
	}

	function _panel_document($client_id, $id)
	{
		$this->load->model('repo_docs_m');
		$doc = $this->repo_docs_m->get_custom_one($id);
		if(empty($doc)){show_404();}
		$data = array();
		$data['box_icon'] = "fa fa-file-o";
		$data['box_title'] =lang('document')." ".$doc['name'];
		$data['box_content'] = $this->load->view('repo/doc', $doc, TRUE);
		$this->load->model('clients_repo_docs_m');
		$ids = $this->clients_repo_docs_m->get_ids_by_client_id($client_id);
		if(in_array($id, $ids)){
			$data['box_buttons'] = anchor('clients_repo_docs/delete/'.$client_id.'/'.$id,'<i class="fa fa-times"></i> '.lang('clients_repo_docs_delete'), 'class="btn btn-danger btn-sm pull-right" target="#clients_repo_docs_tree_content"');
		}else{
			$data['box_buttons'] = anchor('clients_repo_docs/create/'.$client_id.'/'.$id,'<i class="fa fa-plus"></i> '.lang('clients_repo_docs_create'), 'class="btn btn-success btn-sm pull-right" target="#clients_repo_docs_tree_content"');
		}
		return $data;
	}

	/**
	  * Return layout view for create section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int|null $doc_id Document ID
	  */
	function create($client_id, $doc_id=NULL)
	{
		$this->clients_repo_docs_m->set_doc_id($doc_id);
		$this->clients_repo_docs_m->set_client_id($client_id);

		$doc_id				= $doc_id==NULL ? 'root' : 'd_'.$doc_id;
		$back				= 'clients_repo_docs/tree_panel/'.$client_id.'/'.$doc_id;

		$this->load->view('crud/create', $this->_create($back, '#clients_repo_docs_tree_content'));
	}

	/**
	  * Return layout view for delete section of crud.
	  *
	  * @param int $client_id Client ID
	  * @param int $id ID
	  */
	function delete($client_id, $id)
	{
		$this->load->model('repo_docs_m');

		$doc				= $this->repo_docs_m->get_one($id);
		$cat_id				= $doc['category_id']==NULL ? 'root' : 'c_'.$doc['category_id'];
		$client_doc			= $this->clients_repo_docs_m->get_by_client_doc($client_id, $id);
		if(!isset($client_doc['id']))
		{
			show_404();
		}
		$back				= 'clients_repo_docs/tree_panel/'.$client_id.'/d_'.$id;

		$this->load->view('crud/delete', $this->_delete($client_doc['id'], $back, '#clients_repo_docs_tree_content', NULL, FALSE));
	}

}