<?php
 /**
  * Controller for Docs assignment
  *
  * This is the controller used to Docs assignment section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Docs_assignment - Controller
  *
  * Controller for Docs assignment section.
  */
class Docs_assignment extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'docs_assignment_m';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->icon			= 'fa fa-cogs';
		$this->main_title	= lang('menu_docs_assignment');
		$this->main_tip		= lang('docs_assignment_tip');
		$this->create_title	= lang('docs_assignment_create');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table(anchor('docs_assignment/create','<i class="fa fa-plus"></i> '.lang('docs_assignment_create'), 'class="btn btn-primary btn-sm"'));
	}

	/**
	  * Return layout view for create section of crud.
	  */
	function create()
	{
		$name				= strtolower(get_class($this));
		$data				= array_merge($this->_create($name), array(
			'businessPartner'	=> $this->session->userdata('business_partner')	
		));

		$this->show_template('docs_assignment/create', $data);
	}

	/**
	  * Return layout view for edit section of crud.
	  *
	  * @param int $id ID
	  */
	function edit($id)
	{
		$name				= strtolower(get_class($this));
		$data				= array_merge($this->_edit($id, $name), array(
			'businessPartner'	=> $this->session->userdata('business_partner')	
		));

		$this->show_template('docs_assignment/edit', $data);
	}

	/**
	  * This callback runs on each row. It set action column content.
	  *
	  * @param array $row Array containing all row data 
	  */
	function _callback_previous_row(&$row)
	{
		$item				= anchor('docs_assignment/edit/'.$row->id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
		$item				.= "&nbsp;";
		$item				.= anchor('docs_assignment/delete/'.$row->id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');

		$row->action		= $item;
	}

	/**
	  * Return users & documents in JSON for a specified partner ID
	  *
	  * @return string
	  */
	function dataByPartner()
	{
		$this->load->model('users_bpartner_m');
		$this->load->model('repo_docs_m');

		$partner_id			= $this->input->get('partner_id');
		
		echo json_encode(array(
			'users'			=> $this->users_bpartner_m->get_by_business_partner_id($partner_id),
			'documents'		=> $this->repo_docs_m->get_repo_docs_list_by_bp($partner_id)
		));
	}
}