<?php 
 /**
  * Controller for Docs bundles
  *
  * This is the controller used to Docs bundles section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Docs_bundles - Controller
  *
  * Controller for Docs bundles section.
  */
class Docs_bundles extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'docs_bundles_m';

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();

		$this->icon			= 'fa fa-th-large';
		$this->main_title	= lang('menu_docs_bundles');
		$this->main_tip		= lang('docs_bundles_tip');
		$this->create_title	= lang('docs_bundles_create');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table(anchor('docs_bundles/create','<i class="fa fa-plus"></i> '.lang('docs_bundles_create'), 'class="btn btn-primary btn-sm"'));
	}

	/**
	  * This callback runs on each row. It set action column content.
	  *
	  * @param array $row Array containing all row data 
	  */
	function _callback_previous_row(&$row)
	{
		$item				= anchor('docs_bundles/edit/'.$row->id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
		$item				.= "&nbsp;";
		$item				.= anchor('docs_bundles/delete/'.$row->id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');

		$row->action		= $item;
	}

	/**
	  * Retrieve and generate a form_dropdown friendly JSON
	  *
	  * @param int $id Business partner ID
	  *
	  * @return string
	  */
	function get_repo_docs_list_by_bp($id)
	{
		$this->load->model('docs_bundles_m');
		
		echo json_encode($this->docs_bundles_m->get_repo_docs_list_by_bp($id));
	}
}