<?php
 /**
  * Controller for Migrations
  *
  * This is the controller used to Migration system.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migrate - Controller
  *
  * Controller for Migrations.
  */
class Migrate extends CI_Controller
{
	/**
	  * Constructor
	  */
	public function __construct()
	{
		parent::__construct();

		if(!$this->input->is_cli_request())
			show_404();//exit("Execute via command line: php index.php migrate/latest");

		$this->load->library('migration');
	}

	/**
	  * Migrates up to the latest version
	  */
	public function latest()
	{
		if(!$this->migration->latest())
		{
			show_error($this->migration->error_string());
		}
	}

	/**
	  * Migrates up to the current version
	  *
	  * @param int $index Index Version
	  */
	public function current($index)
	{
		if(!is_numeric($index) || (int)$index != $index || $index < 0) {
			echo "Invalid parameter: only positive integers and 0 accepted\r\n";
			return;
		}

		$current_version	= $this->migration->version($index);

		if($current_version < 0 || (is_bool($current_version) && $current_version == FALSE))
		{
			show_error($this->migration->error_string());
		}
	}
}