<?php 
 /**
  * Controller for Notifications
  *
  * This is the controller used to Notifications.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  * @ignore
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Notifications - Controller
  *
  * Controller for Notifications section.
  */
class Notifications extends MY_Controller {

	var $model = 'notifications_m';
	var $edit_view  = 'notifications/edit';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = lang('menu_notifications');
		$this->edit_title = lang('notification_edit');
		$this->main_tip = lang('notifications_tip');
		$this->create_title = lang('notifications_create');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table(anchor('notifications/create','<i class="fa fa-plus"></i> '.lang('notifications_create'), 'class="btn btn-primary btn-sm"'));
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column 
	  * @param mixed $value Value 
	  * @param array $row Array containing all row data 
	  *
	  * @return string
	  */
	function _callback_row($key, $item, &$rows){
		switch ($key) {
			case 'id':
				$id = $item;
				$item = anchor('notifications/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
				$item .= "&nbsp;"; 
				$item .= anchor('notifications/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');
				break;
		}
		 return $item===NULL? '' : $item; 
	}
	
}