<?php 
 /**
  * Controller for Notifications send
  *
  * This is the controller used to Notifications send section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  * @ignore
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Notifications_send - Controller
  *
  * Controller for Notifications send section.
  */
class Notifications_send extends MY_Controller {

	/** @var string This is the model associated to the controller. */
	var $model = 'clients_m';
	/** @var string This is the title for layout view. */
	var $notification_id;

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = lang('menu_notifications');
		$this->main_tip = lang('notifications_tip');
	}

	/**
	  * index
	  *
	  * @param int $notification_id
	  */
	function index($notification_id)
	{
		$this->add_pre_breadcum('notifications', '<i class="fa fa-bullhorn"></i> '. lang('menu_notifications'));
		$name = strtolower(get_class($this));
		$data = array();
		$data['values'] = array('id' => $notification_id);
		$data['table_id'] = $name."_table"; 
		$data['toolbar'] = ''; 
		$data['items_source'] = $name.'/table/'.$notification_id; 
		$data['items_table'] = $this->_get_items('table');
		$data['content_view'] = "crud/table";
		$this->show_template('notifications/edit', $data);
	}

	/**
	  * table
	  *
	  * @param int $notification_id
	  */
	public function table($notification_id)
	{
		$this->notification_id = $notification_id;
		$this->load->view('output/json', array('json' => $this->_ajax_table()));
	}

	/**
	  * send
	  *
	  * @param int $client_id
	  */
	public function send($client_id)
	{
        $notification_id = $this->input->post('notification_id');

        if(!$this->notify($notification_id, $client_id)){
            echo lang('notification_send_error');
            return;
        }

		$this->load->model('notifications_clients_m');
		$id = $this->notifications_clients_m->insert(array('client_id' => $client_id, 'notification_id' => $notification_id, 'push_sent' => 1));
		if($id>0){
			echo lang('notification_send_ok');
		}else{
			echo lang('notification_send_error');
		}
	}

	/**
	  * notify
	  *
	  * @param int $notification_id
	  * @param int $client_id
	  */
    private function notify($notification_id, $client_id)
    {
        if (!$notification_id || !$client_id)
            return false;

        // notification
        $this->load->model('notifications_m');
        $notification = $this->notifications_m->get_one($notification_id);
        if (!$notification || !isset($notification['push']) || $notification['push'] != 1)
            return false;

        // client
        $this->load->model('clients_m');
        $client = $this->clients_m->get_one($client_id);
        if (!$client || !isset($client['external_id']))
            return false;

        return push_send($client['external_id'], lang("app_title") . ': ' . $notification['title']);
    }

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column 
	  * @param mixed $value Value 
	  * @param array $row Array containing all row data 
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$row)
	{
		switch ($key) {
			case 'id':
				$id					= $value;
				$value				= form_open('notifications_send/send/'.$id, array('id' => 'ns_'.$id, 'target' => '#ns_'.$id, 'class' => 'ajax'));
				$value				.= form_hidden('notification_id', $this->notification_id);
				$value				.= '<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-send"></i> '.lang('notification_send').'</button>';
				$value				.= form_close();
				break;
		}

		return $value===NULL? '' : $value; 
	}

	/**
	  * This callback runs on query for table of the crud.
	  * Use to add where clause on the query
	  *
	  */
	function _callback_filter()
	{
		return "clients.id NOT IN (SELECT notifications_clients.client_id FROM notifications_clients WHERE notification_id=".$this->notification_id.")";
	}
	
}