<?php
 /**
  * Controller for Parameters
  *
  * This is the controller used to Parameters section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Parameters - Controller
  *
  * Controller for Parameters section.
  */
class Parameters extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model			= 'parameters_m';
	/** @var string This is the edit view associated to the section. */
	var $edit_view 		= 'parameters/edit';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->create_title	= lang('parameters_create');
		$this->icon			= 'fa fa-wrench';
		$this->main_tip		= lang('parameters_tip');
		$this->main_title	= lang('menu_parameters');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table(anchor('parameters/create','<i class="fa fa-plus"></i> '.lang('parameters_create'), 'class="btn btn-primary btn-sm"'));
	}

	/**
	  * Return layout view for edit section of crud.
	  *
	  * @param int $id ID
	  */
	function edit($id)
	{
		$client				= $this->parameters_m->get_one($id);
		$this->main_title	= $client['name'];

		parent::edit($id);
	}

	/**
	  * This callback runs on each row. It set action column content.
	  *
	  * @param array $row Array containing all row data
	  */
	function _callback_previous_row(&$row)
	{
		$item				= anchor('parameters/edit/'.$row->id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
		$item				.= "&nbsp;";
		$item				.= anchor('parameters/delete/'.$row->id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');

		$row->action		= $item;
	}
}