<?php 
 /**
  * Controller for Profile
  *
  * This is the controller used to Profile section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Profile - Controller
  *
  * Controller for Profile section.
  */
class Profile extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'admin_m';
	/** @var array Current user data. */
	var $current_user = NULL;

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->icon			= 'fa fa-user';
		$this->current_user	= $this->login_m->get_user();
		$this->edit_title	= lang('profile_edit');
		$this->main_title	= $this->current_user['fullname'];
		$this->main_tip		= lang('profile_tip');
	}

	/**
	  * Redirect to home.
	  * This controller don't need index section but to prevent errors do redirection to home.
	  *
	  */
	function index()
	{
		redirect('/');
	}

	/**
	  * Return layout view for edit section of crud.
	  *
	  * @param int $id ID
	  */
	function edit()
	{
		parent::edit($this->current_user['id']);
	}
}