<?php 
 /**
  * Controller for Repo
  *
  * This is the controller used to Repo section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Repo - Controller
  *
  * Controller for Repo section.
  */
class Repo extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = '';

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();

		$this->icon			= 'fa fa-book';
		$this->main_title	= lang('menu_repo');
		$this->main_tip		= lang('repo_tip');
	}

	/**
	  * Show view tree template
	  *
	  */
	function index()
	{
		$this->_tree($this->tree_panel());
	}

	/**
	  * Return JSON with elements for tree
	  *
	  */
	function tree_source()
	{
		$this->load->model('repo_categories_m');
		$this->load->model('repo_docs_m');

		$id					= $this->input->post('id');
		$data				= [];
		if($id == '#')
		{
			$data[]				=  [
				'id'				=> 'root', 
				'children'			=> TRUE, 
				'text'				=> lang('repo_root'), 
				'icon'				=> 'fa fa-book',
				'state'				=>  [
					'opened'			=> TRUE
				]
			];
		}
		if($id == 'root')
		{

			$cats				= $this->repo_categories_m->get_by_parent(null);
			foreach($cats as $cat)
			{
				$data[]				= [
					'id'				=> 'c_'.$cat['id'], 
					'children'			=> TRUE, 
					'icon'				=> 'fa fa-folder-open-o',
					'text'				=> $cat['category_name']
				];
			}
			
			$docs				= $this->repo_docs_m->get_by_category_id(null);
			foreach($docs as $doc)
			{
				$data[]				= [
					'id'				=> 'd_'.$doc['id'], 
					'children'			=> FALSE, 
					'icon'				=> 'fa fa-file-o',
					'text'				=> $doc['name']
				];
			}
		}

		if(substr($id, 0, 2)=='c_')
		{
			$id					= str_replace('c_', '', $id);
			$cats				= $this->repo_categories_m->get_by_parent($id);
			foreach($cats as $cat)
			{
				$data[]				= [
					'id'				=> 'c_'.$cat['id'], 
					'children'			=> TRUE, 
					'icon'				=> 'fa fa-folder-open-o',
					'text'				=> $cat['category_name']
				];
			}

			$docs				= $this->repo_docs_m->get_by_category_id($id);
			foreach($docs as $doc)
			{
				$data[]				= [
					'id'				=> 'd_'.$doc['id'], 
					'children'			=> FALSE, 
					'icon'				=> 'fa fa-file-o',
					'text'				=> $doc['name']
				];
			}
		}
		
		$this->load->view('output/json', array('json' =>$data));
	}

	/**
	  * Show proper view to rigth side on tree view
	  *
	  * @param int $id ID
	  */
	function tree_panel($id = NULL)
	{
		if($id==NULL)
		{
			$refresh			= FALSE;
			$id					= $this->input->post('id');
		}else{
			$refresh			= TRUE;
		}
		$item_tree_id		= $id;
		$data				= [];
		if(!$id)
		{
			return $this->load->view('items/box', $this->_panel_welcome(), TRUE);
		} elseif($id=='root')
		{
			$data				= $this->_panel_root();
		}else{
			switch(substr($id, 0, 2))
			{
				case 'c_':
					$id					= str_replace('c_', '', $id);
					$data				= $this->_panel_category($id);
					break;
				case 'd_':
					$id					= str_replace('d_', '', $id);
					$data				= $this->_panel_document($id);
					break;
			}
		}

		$this->load->view('items/box', $data);
		if($refresh)
		{
			$this->load->view('crud/tree_refresh', array('tree_id' => '#repo_tree', 'id' => $item_tree_id));
		}
	}

	/**
	  * View to rigth side on tree view, Shows when ID is null
	  *
	  */
	function _panel_welcome()
	{
		return [
			'box_icon'			=> "fa fa-book",
			'box_title'			=> lang('repo_management'),
			'box_content'		=> $this->load->view('repo/welcome', NULL, TRUE)
		];
	}

	/**
	  * View to rigth side on tree view, Shows when ID is root
	  *
	  */
	function _panel_root()
	{
		$box_buttons		= anchor('repo_categories/create','<i class="fa fa-folder-o"></i> '.lang('repo_categories_create'), 'class="btn btn-primary btn-sm" target="#repo_tree_content"');
		$box_buttons		.= anchor('repo_docs/create','<i class="fa fa-file-o"></i> '.lang('repo_docs_create'), 'class="btn btn-primary btn-sm pull-right" target="#repo_tree_content"');

		return [
			'box_icon'			=> "fa fa-book",
			'box_title'			=> lang('repo_root'),
			'box_content'		=> $this->load->view('repo/root', NULL, TRUE),
			'box_buttons'		=> $box_buttons
		];
	}

	/**
	  * View to rigth side on tree view, Shows when ID contain c_ string
	  *
	  * @param int $id ID
	  */
	function _panel_category($id)
	{
		$this->load->model('repo_categories_m');

		$cat				= $this->repo_categories_m->get_custom_one($id);
		if(empty($cat))
		{
			show_404();
		}

		$box_top_buttons	 = anchor('repo_categories/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm" target="#repo_tree_content"');
		$box_top_buttons	.= "&nbsp;"; 
		$box_top_buttons	.= anchor('repo_categories/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm" target="#repo_tree_content"');

		$box_buttons		= anchor('repo_categories/create/'.$id,'<i class="fa fa-folder-o"></i> '.lang('repo_categories_create'), 'class="btn btn-primary btn-sm" target="#repo_tree_content"');
		$box_buttons		.= anchor('repo_docs/create/'.$id,'<i class="fa fa-file-o"></i> '.lang('repo_docs_create'), 'class="btn btn-primary btn-sm pull-right" target="#repo_tree_content"');

		return [
			'box_icon'			=> "fa fa-folder-o",
			'box_title'			=> lang('category')." ".$cat['category_name'],
			'box_content'		=> $this->load->view('repo/category', $cat, TRUE),
			'box_top_buttons'	=> $box_top_buttons,
			'box_buttons'		=> $box_buttons
		];
	}

	/**
	  * View to rigth side on tree view, Shows when ID contain d_ string
	  *
	  * @param int $id ID
	  */
	function _panel_document($id)
	{
		$this->load->model('repo_docs_m');

		$doc				= $this->repo_docs_m->get_custom_one($id);
		if(empty($doc))
		{
			show_404();
		}

		$box_top_buttons	= anchor('repo_docs/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm" target="#repo_tree_content"');
		$box_top_buttons	.= "&nbsp;"; 
		$box_top_buttons	.= anchor('repo_docs/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm" target="#repo_tree_content"');

		return [
			'box_icon'			=> "fa fa-file-o",
			'box_title'			=> lang('document')." ".$doc['name'],
			'box_content'		=> $this->load->view('repo/doc', $doc, TRUE),
			'box_top_buttons'	=> $box_top_buttons
		];
	}
}