<?php
 /**
  * Controller for User groups bundles
  *
  * This is the controller used to User groups bundles section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class User_groups_bundles - Controller
  *
  * Controller for User_groups_bundles section.
  */
class User_groups_bundles extends MY_Controller {

	/** @var string This is the model associated to the controller. */
	var $create_view = 'user_groups_bundles/table';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->icon			= 'fa fa-object-group';
		$this->main_title	= lang('menu_user_groups_bundles');
		$this->main_tip		= lang('user_groups_bundles_tip');
		$this->create_title	= lang('user_groups_bundles_create');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->show_template('user_groups_bundles/table', []);
	}
}