<?php
 /**
  * Helper for PUSH
  *
  * This is a helper to send push.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage helpers
  *
  */
if (!function_exists('operation_message'))
{
	/**
	  * Return an Operation message view 
	  *
	  */
	function operation_message()
	{
		$ci					= get_instance();

		$message			= null;
		$success			= $ci->session->flashdata('success');
		$failure			= $ci->session->flashdata('failure');
		if(!empty($success))
		{
			$message 			= $success;
			$type				= 'success';
		}
		if(!empty($failure))
		{
			$message 			= $failure;
			$type				= 'danger';
		}
	
		if(!is_null($message))
		{

			$ci->load->view('common/operation_message', array(
				'message'			=> $message,
				'type'				=> $type
			));
		}
	}
}

if (!function_exists('checkIsManager'))
{
	/**
	  * Return true if actual user has role Manager 
	  *
	  */
	function checkIsManager()
	{
		$ci = get_instance();

		if((int)$ci->session->userdata('user_role') != 2)
		{
			return false;
		}

		return true;
	}
}
