<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_clients_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('clients'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'BIGINT',
					'constraint' => 20,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'external_id' => array(
					'type' => 'VARCHAR',
					'constraint' => '255',
				),
				'name' => array(
					'type' => 'VARCHAR',
					'constraint' => '256',
				),
				'surname' => array(
					'type' => 'VARCHAR',
					'constraint' => '512',
				),
				'partner_id' => array(
					'type' => 'VARCHAR',
					'constraint' => '50',
					'default' => NULL,
					'null' => TRUE,
				)
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('clients');
			$this->db->query('ALTER TABLE clients ADD UNIQUE INDEX external_id (external_id)');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down() 
	{
		if($this->db->table_exists('clients'))
			$this->dbforge->drop_table('clients');
	}
}