<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_clients_categories_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('clients_categories'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'INT',
					'constraint' => 11,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'`parent_id` INT(11) UNSIGNED DEFAULT NULL',
				'cat_id' => array(
					'type' => 'VARCHAR',
					'constraint' => '150',
					'default' => NULL,
					'null' => TRUE,
				),
				'client_id' => array(
					'type' => 'BIGINT',
					'constraint' => '20',
					'unsigned' => TRUE,
				),
				'`admin_id` int(11) DEFAULT NULL',
				'category_name' => array(
					'type' => 'VARCHAR',
					'constraint' => '255',
				),
				'short_desc' => array(
					'type' => 'TEXT',
				),
				'image' => array(
					'type' => 'VARCHAR',
					'constraint' => '200',
				),
				'order' => array(
					'type' => 'INT',
					'constraint' => '11',
				),
				'isinvoice' => array(
					'type' => 'TINYINT',
					'constraint' => '1',
					'default' => 0,
					'null' => TRUE,
				),
				'`created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP',
				'`updated_at` timestamp NULL DEFAULT NULL',
				'KEY `parent_id` (`parent_id`)',
				'KEY `client_id` (`client_id`)',
				'CONSTRAINT `clients_categories_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `clients_categories` (`id`)',
				'CONSTRAINT `clients_categories_ibfk_2` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`)',
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('clients_categories');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down() 
	{
		if($this->db->table_exists('clients_categories'))
			$this->dbforge->drop_table('clients_categories');
	}
}