<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_notifications_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('notifications'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'BIGINT',
					'constraint' => 20,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'`admin_id` int(11) DEFAULT NULL',
				'create_date' => array(
					'type' => 'DATETIME',
				),
				'date' => array(
					'type' => 'DATE',
				),
				'time' => array(
					'type' => 'TIME',
				),
				'title' => array(
					'type' => 'VARCHAR',
					'constraint' => 255,
				),
				'description' => array(
					'type' => 'TEXT',
				),
				'place' => array(
					'type' => 'TEXT',
				),
				'push' => array(
					'type' => 'TINYINT',
					'constraint' => 1,
				),
				'`created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
				'`updated_at` timestamp NULL DEFAULT NULL',
				'organizer' => array(
					'type' => 'TEXT',
					'null' => TRUE,
				),
				'contact_details' => array(
					'type' => 'TEXT',
					'null' => TRUE,
				),
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('notifications');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down() 
	{
		if($this->db->table_exists('notifications'))
			$this->dbforge->drop_table('notifications');
	}
}