<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_notifications_clients_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('notifications_clients'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'BIGINT',
					'constraint' => 20,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'notification_id' => array(
					'type' => 'BIGINT',
					'constraint' => 20,
					'unsigned' => TRUE,
				),
				'client_id' => array(
					'type' => 'BIGINT',
					'constraint' => 20,
					'unsigned' => TRUE,
				),
				'push_sent' => array(
					'type' => 'TINYINT',
					'constraint' => 1,
				),
				'UNIQUE KEY `notification_id_2` (`notification_id`,`client_id`)',
				'KEY `notification_id` (`notification_id`)',
				'KEY `client_id` (`client_id`)',
				'CONSTRAINT `notifications_clients_ibfk_1` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`id`)',
				'CONSTRAINT `notifications_clients_ibfk_2` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`)',
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('notifications_clients');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down() 
	{
		if($this->db->table_exists('notifications_clients'))
			$this->dbforge->drop_table('notifications_clients');
	}
}