<?php
 /**
  * Migration
  *
  * This is the migration used to repo_docs_clients table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Update_relation_on_repo_docs_clients - Migration
  *
  * Migration for repo_docs_clients table.
  */
class Migration_Update_relation_on_repo_docs_clients extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database
	  */
	public function up()
	{
		$this->db->query("ALTER TABLE `repo_docs_clients` DROP FOREIGN KEY `repo_docs_clients_ibfk_1`;");
		$this->db->query("ALTER TABLE `repo_docs_clients` ADD CONSTRAINT `repo_doc_client_fk_repo_doc` FOREIGN KEY (`repo_doc_id`) REFERENCES `repo_docs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;");
	}

	/**
	  * Used to revert that change that was done by the up() method
	  */
	public function down()
	{
		$this->db->query("ALTER TABLE `repo_docs_clients` DROP FOREIGN KEY `repo_doc_client_fk_repo_doc`;");
		$this->db->query("ALTER TABLE `repo_docs_clients` ADD CONSTRAINT `repo_docs_clients_ibfk_1` FOREIGN KEY (`repo_doc_id`) REFERENCES `repo_docs` (`id`);");
	}
}