<?php
 /**
  * Model for languages table
  *
  * This is the model for languages table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Languages_m - Model
  *
  * Model for languages table.
  */
class Languages_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
    var $table = "languages";

	/**
	  * Constructor
	  */
    function __construct()
    {
        parent::__construct();
    }

	/**
	  * Fetch all the records in the table.
	  *
	  * @return array
	  */
    function get_languages()
    {
        $query				= $this->db->select('id as value, name as text')
					        ->order_by('order', 'ASC')
					        ->get($this->table);

        return $query->result_array();
    }
	/**
	  * Fetch a single record based on the primary key. Return folder name string based on iso column
	  *
	  * @param int $id ID
	  *
	  * @return array
	  */
    function get_name($id)
    {
        $query				= $this->db->select('iso')
					        ->where('id', $id)
					        ->get($this->table);
        switch($query->row()->iso)
        {
            case "en":
                $name = 'english';
                break;
            case "es":
                $name = 'spanish';
                break;
            case "de":
                $name = 'german';
                break;
            case "it":
                $name = 'italian';
                break;
            case "fr":
                $name = 'french';
                break;
        }

        return $name;
    }
}