<?php
 /**
  * Model for login
  *
  * This is the model used to login system.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Login_m - Model
  *
  * Model for admin table.
  */
class Login_m extends CI_Model
{
	 /** @var string This is the name of the primary key field for our model. */
	protected $primary_key = 'id';
	 /** @var string This is the database table for this model. */
	protected $table = 'admin';
	 /** @var int This is private var to use on this class. */
	protected $session_var = 'manager';
	 /** @var int This is private var to use on this class. */
	private $user = NULL;

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
	}

	/**
	  * Fetch a single record based on the primary key. Return an array
	  *
	  * @param int $id ID for primary key
	  *
	  * @return array
	  */
	function get_user()
	{
		if($this->user == NULL)
		{
			$this->user			= $this->db->where($this->primary_key, $this->get_user_id())
								->get($this->table)
								->row_array();
		}

		return $this->user;
	}

	/**
	  * Retrieve ID of user located on session
	  *
	  * @return array
	  */
	function get_user_id()
	{
		return $this->session->userdata($this->session_var);
	}

	/**
	  * Try to make login with provided params
	  *
	  * @param string $user Username
	  * @param string $pass Password
	  *
	  * @return int
	  */
	function login($user, $pass)
	{
		$user_id			= null;
		$query				= $this->db->select(array($this->primary_key,'user_role', 'business_partner'))
							->where('password !=', '')
							->where('user', strtolower($user))
							->where('password', md5($pass))
							->get($this->table);

		if ($query->num_rows() > 0)
		{
			$row				= $query->row_array();
			$user_id			= $row[$this->primary_key];

			$this->session->set_userdata($this->session_var, $user_id);
			$this->session->set_userdata('user_role', $row['user_role']);
			$this->session->set_userdata('business_partner', (!empty($row['business_partner'])?$row['business_partner']:0));
		} else {
			$this->logout();
		}

		return $user_id;
	}

	/**
	  * Check if user have permision
	  *
	  * @param string $permission Username
	  * @param true|false $redirect
	  *
	  * @return int
	  */
	function user_has_role($permission, $redirect = false )
	{
		if($user = $this->get_user())
		{
			$role				= $user['user_role'];
			if(is_int($permission))
			{
				if((int)$role === $permission)
				{
					return true;
				}
			} else if(is_array($permission))
			{
				if(in_array($role, $permission ))
				{
					return true;
				}
			}
		}

		if(!$redirect)
		{
			return false;
		} else {
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	/**
	  * Delete user session
	  */
	function logout()
	{
		$this->session->unset_userdata($this->session_var);
	}

	/**
	  * Check if user is logged
	  *
	  * @return true|false
	  */
	function is_loged_in()
	{
		$user_id = $this->get_user_id();
		if(!empty($user_id))
		{
			return TRUE;
		}

		return FALSE;
	}
}