<?php
 /**
  * Model for parameters table
  *
  * This is the model for parameters table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Parameters_m - Model
  *
  * Model for parameters table.
  */
class Parameters_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "parameters";

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * Fetch a single record based on the name column. Return an array
	  *
	  * @param string $name Name
	  *
	  * @return array
	  */
	function get_by_name($name)
	{
		$this->primary_key	= 'name';
		$results			= $this->get_one($name);
		$this->primary_key	= 'id';

		return $results;
	}
}	