<?php
$error_str = form_error($item['field'],'<remove>','<remove>');
$error_str = str_ireplace('<remove>', '', $error_str);
$has_error = false;
if ($error_str!=''){
	$has_error = true;
}
?>
<div class="form-group<?php echo $has_error ? ' has-error' : '' ; ?>">
	<label id="<?php echo $item['field']; ?>_label" for="<?php echo $item['field']; ?>_upload"
		<?php if($has_error){ ?>data-toggle="tooltip" data-placement="top" title="<?php echo $error_str; ?>" <?php } ?>
		>
		<?php echo $item['label']; ?>
		<?php if(isset($item['rules']) AND (strpos($item['rules'], 'required') !== false)){ ?>
			<span class="text-danger">*</span>
		<?php } ?>
		<?php if($has_error){ ?>
			<i class="fa fa-times-circle-o"></i>
		<?php } ?>
	</label>
	<div id="<?php echo $item['field'].'_upload'; ?>">Upload</div>
	<div class="row">
		<div class="col-sm-12">
	<?php if(isset($item['filetype']) && $item['filetype'] == 'image'){ ?>
		<?php if(empty($item['value'])){ ?>
			<?php echo lang('no_image_selected'); ?>
		<?php }else{ ?>
			<div class="preview-pane" id="<?php echo $item['field'].'_preview'; ?>">
				<div class="preview-container">
					<img src="<?php echo site_url('/uploader/view/'.$item['dir'].$item['value']); ?>" class="jcrop-preview" alt="Preview" />
				</div>
			</div>
		<?php } ?>

	<?php }else{ ?>
		<?php if(empty($item['value'])){ ?>
			<?php echo lang('no_file_selected'); ?>
		<?php }else{ ?>
			<div class="preview-pane" id="<?php echo $item['field'].'_preview'; ?>">
				<?php echo anchor('/uploader/view/'.$item['dir'].$item['value'], '<i class="fa fa-file" title="Ver fichero seleccionado..." style="font-size: 36px"></i>', array('target' => '_blank')); ?>
			</div>
		<?php } ?>
	<?php } ?>
		<i id="removeFile_<?php echo $item['field']; ?>" class="fa fa-trash fa-lg text-danger" style="position: absolute; top: 10px; right: 10px;"></i>
		<input type="hidden" id="<?php echo $item['field']; ?>" name="<?php echo $item['field']; ?>" value="<?php echo $item['value']; ?>" />
		</div>
	</div>
	<?php if($has_error){?>
	<script type="text/javascript">
		$(document).ready(function(){
		    $('#<?php echo $item['field']; ?>_label').tooltip({template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow text-red"></div><div class="tooltip-inner bg-red"></div></div>'});
		});
	</script>
	<?php } ?>
	<script>
		$(document).ready(function()
		{
			$('#removeFile_<?php echo $item['field']; ?>').on('click', function(){
				$(this).hide();
				$('#<?php echo $item['field']; ?>').val('');
				$('#<?php echo $item['field'].'_preview'; ?>').css('display','none');
			});

			$("#<?php echo $item['field'].'_upload'; ?>").uploadFile({
				url:'<?php echo site_url('uploader'); ?>',
				fileName:"Filedata",
				multiple:false,
				maxFileCount:1,
				<?php if(isset($item['filetype']) && $item['filetype'] == 'image'){ ?>
				//acceptFiles:"image/*",
				allowedTypes: 'gif,jpg,jpeg,png',
				<?php } else { ?>
				//acceptFiles: "application/*",
				allowedTypes: 'gif,jpg,jpeg,png,doc,docx,pdf',
				<?php } ?>
				showDelete: true,
				showPreview:true,
				previewHeight: "100px",
				previewWidth: "100px",
				//cancelStr:"résilier",
				//uploadStr:"Téléchargez"
				onSuccess:function(files,data,xhr,pd)
				{
					$('#<?php echo $item['field']; ?>').val('[#POOL#]'+data);
					<?php if(isset($item['filetype']) && $item['filetype'] == 'image'){ ?>
							$('#<?php echo $item['field'].'_preview'; ?>').css('display','none');
						<?php } else { ?>
							$('#<?php echo $item['field'].'_preview'; ?>').html('<a href="<?php echo site_url('uploader/view/pool'); ?>/'+data+'" target="_blank"><?php echo lang('view_selected_file'); ?></a>');
					<?php } ?>
				},
			});
		});
	</script>
</div>