<?php
$error_str = form_error($item['field'],'<remove>','<remove>');
$error_str = str_ireplace('<remove>', '', $error_str);
$has_error = false;
if ($error_str!=''){
	$has_error = true;
}
?>
<div class="form-group<?php echo $has_error ? ' has-error' : '' ; ?>">
	<label for="<?php echo $item['field']; ?>">
		<?php echo $item['label']; ?>
		<?php if(isset($item['rules']) AND (strpos($item['rules'], 'required') !== false)){ ?>
			<span class="text-danger">*</span>
		<?php } ?>
		<?php if($has_error){ ?>
			<i class="fa fa-times-circle-o"></i>
		<?php } ?>
	</label>
	<?php if(isset($item['icon'])){ ?>
	<div class="input-group">
		<span class="input-group-addon">
			<i class="<?php echo $item['icon']; ?>"></i>
		</span>
	<?php } ?>
		<input
			<?php if(isset($item['mask'])){?> 
			data-inputmask="'mask': ['<?php echo $item['mask']; ?>']" 
			<?php echo (isset($item['greedy']) && $item['greedy']==FALSE) ? 'data-inputmask-greedy="false"' : ''; ?> 
			data-inputmask-showMaskOnHover="false" 
			data-inputmask-removeMaskOnSubmit="true" 
			data-inputmask-clearIncomplete="true" 
			<?php } ?> 
			type="password" 
			id="<?php echo $item['field']; ?>" 
			name="<?php echo $item['field']; ?>" 
			placeholder="<?php echo $item['label']; ?>" 
			class="<?php echo (isset($item['inline'])&&$item['inline'])? 'inline ': ''; ?>form-control" 
			<?php if($has_error){ ?>data-toggle="tooltip" data-placement="top" title="<?php echo $error_str; ?>" <?php } ?>
			value="<?php echo htmlspecialchars($item['value']); ?>" />
	<?php if(isset($item['icon'])){ ?>
	</div>
	<?php } ?>
	<?php if(isset($item['mask'])){?>
	<script type="text/javascript">
		$(document).ready(function(){
		    $("#<?php echo $item['field']; ?>").inputmask();
		});
	</script>
	<?php } ?>
	<?php if($has_error){?>
	<script type="text/javascript">
		$(document).ready(function(){
		    $('#<?php echo $item['field']; ?>').tooltip({template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow text-red"></div><div class="tooltip-inner bg-red"></div></div>'});
		});
	</script>
	<?php } ?>
	<script type="text/javascript">
		$(document).ready(function(){
		    $('#<?php echo $item['field']; ?>').val('<?php echo htmlspecialchars($item['value']); ?>');
		});
	</script>
</div>