<!DOCTYPE html>
<html>
	<head>
	    <meta charset="UTF-8">
	    <title><?php echo lang("app_title"); ?> | Application</title>
	    <meta name="google" content="notranslate"/>
	    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	    <meta http-equiv="X-UA-Compatible" content="IE=edge">
	    <!-- jqueryui-->
		<link href="<?php echo base_url('plugins/jquery-ui-1.11.4.custom/jquery-ui.css'); ?>" rel="stylesheet" type="text/css" />
		<!-- Bootstrap 3.3.2 -->
		<link href="<?php echo base_url('bootstrap/css/bootstrap.min.css'); ?>" rel="stylesheet" type="text/css" />
		<!-- FontAwesome 4.3.0 -->
		<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		<?php /*
		<link href="<?php echo base_url('plugins/font-awesome/css/font-awesome.min.css'); ?>" rel="stylesheet" type="text/css" />
		*/ ?>
		<!-- Ionicons 2.0.0 -->
		<link href="<?php echo base_url('plugins/ionicons/css/ionicons.min.css'); ?>" rel="stylesheet" type="text/css" />
		<!-- Theme style -->
		<link href="<?php echo base_url('dist/css/AdminLTE.min.css'); ?>" rel="stylesheet" type="text/css" />
		<!-- AdminLTE Skins. Choose a skin from the css/skins
		     folder instead of downloading all of them to reduce the load. -->
		<link href="<?php echo base_url('dist/css/skins/_all-skins.min.css'); ?>" rel="stylesheet" type="text/css" />
		<!-- iCheck -->
		<link href="<?php echo base_url('plugins/iCheck/flat/blue.css'); ?>" rel="stylesheet" type="text/css" />
	    <!--Data tables-->
		<link href="<?php echo base_url('plugins/datatables/dataTables.bootstrap.css'); ?>" rel="stylesheet" type="text/css" />

	    <script src="<?php echo base_url('plugins/jQuery/jQuery-2.1.3.min.js'); ?>"></script>
	    <script src="<?php echo base_url('bootstrap/js/bootstrap.min.js'); ?>" type="text/javascript"></script>

		<!--Multi select-->
		<script src="<?php echo base_url('bootstrap/js/bootstrap-multiselect.js'); ?>" type="text/javascript"></script>
		<link href="<?php echo base_url('bootstrap/css/bootstrap-multiselect.css'); ?>" type="text/css"/>

	    <script src="<?php echo base_url('plugins/jquery-ui-1.11.4.custom/jquery-ui.js'); ?>" type="text/javascript"></script>
		<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
		<script>$.widget.bridge('uibutton', $.ui.button);</script>
	    <!--Data tables-->
		<script src="<?php echo base_url('plugins/datatables/jquery.dataTables.js'); ?>"></script>
		<script src="<?php echo base_url('plugins/datatables/dataTables.bootstrap.js'); ?>"></script>
	    <script src="<?php echo base_url('dist/js/app.min.js'); ?>" type="text/javascript"></script>
	    <!-- Optionally, you can add Slimscroll and FastClick plugins.
	          Both of these plugins are recommended to enhance the
	          user experience -->

	    <link rel="stylesheet" href="<?php echo base_url('plugins/jstree-3.1.1/themes/default/style.css'); ?>" />
		<script type="text/javascript" src="<?php echo base_url('plugins/jstree-3.1.1/jstree.min.js'); ?>"></script>

	    <link rel="stylesheet" href="<?php echo base_url('plugins/bootstrap-switch-3/css/bootstrap3/bootstrap-switch.css'); ?>" />
		<script type="text/javascript" src="<?php echo base_url('plugins/bootstrap-switch-3/js/bootstrap-switch.js'); ?>"></script>

		<!-- Timepicker -->
		<link rel="stylesheet" href="<?php echo base_url('plugins/timepicker/bootstrap-timepicker.min.css'); ?>" />
		<script type="text/javascript" src="<?php echo base_url('plugins/timepicker/bootstrap-timepicker.min.js'); ?>"></script>

	    <link rel="stylesheet" href="<?php echo base_url('plugins/uploadify/uploadify.css'); ?>" />
	    <script type="text/javascript" src="<?php echo base_url('plugins/uploadify/jquery.uploadify.min.js'); ?>"></script>

		<link rel="stylesheet" href="<?php echo base_url('plugins/uploadfile/uploadfile.css'); ?>" />
		<script type="text/javascript" src="<?php echo base_url('plugins/uploadfile/jquery.uploadfile.min.js'); ?>"></script>

	    <link rel="stylesheet" href="<?php echo base_url('plugins/jcrop/css/jquery.Jcrop.css'); ?>" />
	    <script type="text/javascript" src="<?php echo base_url('plugins/jcrop/js/jquery.Jcrop.js'); ?>"></script>

	    <!--[if lt IE 9]>
	        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
	        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
	    <![endif]-->

	    <link href="<?php echo base_url('favicon.ico'); ?>" rel="shortcut icon" />
	</head>
	<body class="<?php echo $main_skin; ?>">
		<div class="wrapper">
			<header class="main-header">
				<?php echo anchor('', '<b>Document</b> Service', 'class="logo"'); ?>
				<nav class="navbar navbar-static-top" role="navigation">
		          	<a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
		            	<span class="sr-only">Toggle navigation</span>
		          	</a>
		          	<div class="navbar-custom-menu">
		            	<ul class="nav navbar-nav">
              				<li class="dropdown user user-menu">
                				<a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  					<img src="<?php echo site_url('uploader/view/avatar'.$current_user['image']); ?>" class="user-image" alt="User Image"/>
                  					<span class="hidden-xs"><?php echo $current_user['fullname']; ?></span>
                				</a>
								<ul class="dropdown-menu">
									<li class="user-header">
										<img src="<?php echo site_url('uploader/view/avatar'.$current_user['image']); ?>" class="img-circle" alt="User Image" />
										<p>
										<?php echo $current_user['fullname']; ?>
										</p>
                  					</li>
                  					<li class="user-footer">
					                   	<?php if(!defined('APP_FORK') || APP_FORK != 'clients'){ ?>
					                    <div class="pull-left">
					                   		<?php echo anchor('profile/edit', '<i class="fa fa-user"></i> '.lang('profile'), 'class="btn btn-default btn-flat"'); ?>
					                    </div>
					                    <?php } ?>
					                    <div class="pull-right">
					                    	<a class="btn btn-default btn-flat" data-toggle="modal" data-target="#exit-modal"><i class="fa fa-sign-out"></i> <?php echo lang('logout'); ?></a>
					                    </div>
                  					</li>
                				</ul>
              				</li>
            			</ul>
					</div>
				</nav>
			</header>
			<aside class="main-sidebar">
				<section class="sidebar">
					<div class="user-panel">
			            <div class="pull-left image">
			              	<img src="<?php echo site_url('uploader/view/avatar'.$current_user['image']); ?>" class="img-circle" alt="User Image" />
			            </div>
		            	<div class="pull-left info">
		              		<p><?php echo $current_user['fullname']; ?></p>
		            	</div>
	          		</div>
	          		<ul class="sidebar-menu">
	          			<?php foreach($menu as $item){ ?>
							<?php
							if($this->session->userdata('user_role') == 2){
								if($item['url'] == "managers" || $item['url'] == "admin" || $item['url'] == "parameters"){
									continue;
								}
							}
							if($this->session->userdata('user_role') == 1 || $this->session->userdata('user_role') == 2)
								if($item['url'] == "users" || $item['url'] == "notifications") continue;
							?>
					    	<li class="<?php echo $item['class']; ?>">
					    		<?php echo anchor($item['url'], $item['text']); ?>
					    	</li>
					    <?php } ?>
	          		</ul>
        		</section>
			</aside>
      		<!-- Content Wrapper. Contains page content -->
      		<div class="content-wrapper">
        		<section class="content-header">
	          		<h1>
	            		<?php echo isset($icon) ? '<i class="'.$icon.'"></i> ' : '' ; ?><?php echo $main_title; ?> <small><?php echo $main_tip; ?></small>
	          		</h1>
	          		<ol class="breadcrumb">
	            		<?php foreach($breadcum as $item){ ?>
					    	<?php if($item['class'] == 'active'){ ?>
					    		<li class="active"><?php echo $item['text']; ?></li>
					    	<?php }else{ ?>
					    		<li>
					    			<?php echo anchor($item['url'], $item['text']); ?>
					    		</li>
					    	<?php } ?>
					    <?php } ?>
	          		</ol>
        		</section>
        		<section class="content">
					<!-- Your Page Content Here -->
					<?php $this->load->view($main_content); ?>
				</section>
			</div>
			<footer class="main-footer">
				<?php echo lang("app_name"). " - ".$version; ?>
				<div class="pull-right hidden-xs">
					<strong>Copyright &copy; 2017-<?php echo date('Y'); ?> goZmart.</strong> All rights reserved.
				</div>
			</footer>
		</div>
		<div class="modal fade" id="invoice-modal" tabindex="-1" role="dialog" aria-hidden="true">
		</div>
		<div class="modal fade" id="exit-modal" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h4 class="modal-title"><i class="fa fa-sign-out"></i> <?php echo lang("logout_title"); ?></h4>
					</div>
					<form action="<?php echo site_url('login/logout'); ?>" method="post">
						<div class="modal-body">
							<?php echo lang("logout_text"); ?>
						</div>
						<div class="modal-footer clearfix">
							<button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> <?php echo lang("logout_no"); ?></button>
							<button type="submit" class="btn btn-success pull-left"><i class="fa fa-check"></i> <?php echo lang("logout_yes"); ?></button>
						</div>
					</form>
				</div>
			</div>
		</div>
<?php
	operation_message();
?>
<script>
var error_loading_data = "Error";
var loading_data = "Loading information ...";
var error_msg = '<div class="alert alert-danger alert-error"><i class="fa fa-bug"></i><p>'+error_loading_data+'</p></div>';
var loading_msg = '<div class="alert alert-info alert-loading"><i class="fa fa-info"></i><p>'+loading_data+' <i class="icon ion-loading-c"></i></p></div>';

var base_url = "<?php echo base_url(); ?>";

$(function(){
	$.ajaxSetup({
		cache: false
	});

	$(document).ajaxStart(function(){
		new Promise(function(resolve, reject){
			$.get('<?php echo site_url('checklogin') ?>', function(response){
				if(response.success)
				{
					resolve(response.success);
				} else {
					document.location.href = base_url;
				}
			});
		});
	});

	$(document).on("click", "#main_content .sidebar .sidebar-menu a", function(event) {
		$(this).parents('ul:first').find('li').removeClass('active');
	  	$(this).parents('li:first').addClass('active');
	});

    $(document).on("submit", "form", function(event) {
    	var target_form = $(this).attr('target');
    	if(target_form!=undefined && target_form!='_blank') {
			event.preventDefault();
			var to_item = $(this).parent(':first');
			if(target_form!=undefined){
				to_item = $(target_form);
			}

			var ajax_url = $(this).attr('action');
			var ajax_type = $(this).attr('method');
			var ajax_data = $(this).serialize();

			run_ajax(ajax_url, ajax_type, ajax_data, to_item);
		}
	});

    $(document).on("click", "a", function(event) {
		var target_a = $(this).attr('target');
		var data_toggle =  $(this).attr('data-toggle');
		var ajax_url = $(this).attr('href');
		if(data_toggle=='modal' && ajax_url!=undefined){
			target_a = $(this).attr('data-target')+' .modal-content';
			ajax_url =  $(this).attr('data-href');
		}
		if(target_a!=undefined && target_a!='_blank') {
			if(data_toggle!='modal'){
				event.preventDefault();
			}

			var post_dom = $(this).attr('post');
			var ajax_type = (post_dom!=undefined) ? "POST" : "GET";
			var ajax_data = (ajax_type!="POST") ? $('#'+post_dom).serialize() : null;

	        run_ajax(ajax_url, ajax_type, ajax_data, target_a);
		}
	});

	function update_sidebar_menu(url)
	{
		$('.sidebar-menu li').removeClass('active');
		$(".sidebar-menu li a" ).each(function(index) {
			if(url.indexOf($(this).attr('href')) == 0){
				$(this).parent('li').addClass('active');
			}
		});
	}

	function run_ajax(url, type, data, target, history){
			if(target == '#main_content'){
				update_sidebar_menu(url);
				if(history!=false){
					window.history.pushState({type:type,data:data,target:target}, '', url);
				}
			}
			target = $(target);
			$.ajax({
				url: url,
				type: type,
				data: data,
				beforeSend: function(){
					//target.html(loading_msg);
					//target.slideUp();
					target.hide( "fade", {}, "fast", function(){target.html(loading_msg).show();});
				},
				success: function(data){
					var title = data.match(/<title>(.*?)<\/title>/);
					if(title != null){
						document.title = title[1];
					}
					target.stop(true, true).hide().html(data).show("fade", {}, "slow");
				},
				error: function(data, status, error){
					if(status=="error"){
						$.post(infoback_url, { text: data.responseText , url: url});
					}
					target.stop(true, true).hide().html(error_msg).show("fade", {}, "slow");
				}
			});
	}

	window.onpopstate = function(event) {
		var state = event.state;
		if(state==null){
			run_ajax(document.location.href, "GET", null, '#main_content', false);
		}else{
			run_ajax(document.location.href, state.type, state.data, state.target, false);
		}
	};
});

function invoicechecked(id,isinvoice){
		$('#invoice-modal').modal({backdrop: 'static', keyboard: false});
		url = window.location.href + '/invoice';
		$.ajax({
			url: url,
			method: 'POST',
			data: { 'client_id' : id },
			success: function(response){
				$("#invoice-modal").html('');
				$("#invoice-modal").html(response);
				$("#isinvoicecheck").val(isinvoice);
				$("#invoice-modal").modal('show');
			}
		});
		return false;
}

function invoicesubmitted(id){
		$.ajax({
			url: $("#frminvoice").attr('action'),
			method: $("#frminvoice").attr('method'),
			success: function(response){
				var invoiceis = $("#isinvoicecheck").val();
				if (invoiceis == 1){
					$("#isinvoice-"+id).attr("onchange", 'invoicechecked('+id+',0)');  // checked
				} else {
					$("#isinvoice-"+id).attr("onchange", 'invoicechecked('+id+',1)');
				}
				$("#invoice-modal").modal('hide');
				$("#invoice-modal").html('');
			}
		});
		return false;
}

function invoicecancelled(id){
	var invoiceis = $("#isinvoicecheck").val();

	if(invoiceis == 1){
		$("#isinvoice-"+id).prop("checked", true);  // checked
	} else {
		$("#isinvoice-"+id).prop("checked", false);
	}
	$("#invoice-modal").modal('hide');
	$("#invoice-modal").html('');
}
$(function(){

	var ppath = window.location.pathname;

	if(ppath.match('profile/edit')){

		var hvar = '<?php echo($this->session->userdata['user_role']); ?>';
		//$("button").closest("div");
		if(hvar == 1)
			$("#company").closest("div").hide();
	}

});
</script>
	</body>
</html>