$(function () {

    var divUsers = $('[data-users]'),
        divDocuments = $('[data-documents]');

    var selectPartner = $("select#business_partner");

    selectPartner.change(function () {
        var partner_id = $(this).val();

        if (!partner_id) {
            divUsers.empty();
            divDocuments.empty();
            $('<div class="alert alert-info" role="alert">' + selectAPartner + '</div>')
                .appendTo(divUsers)
                .clone()
                .appendTo(divDocuments);
            return false;
        }

        // Obtengo clientes y servicios del partner
        divUsers.html('<div class="text-center"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>');
        divDocuments.html('<div class="text-center"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>');
        $.get(dataByPartnerUrl, { partner_id: partner_id }, function (data) {
	        divUsers.empty();
	        if (!data.users.length) {
	            $('<div class="alert alert-danger" role="alert">' + partnerUsersEmpty + '</div>').appendTo(divUsers);
	            divUsers.prev().addClass('hide');
	        } else {
	            for (var index in data.users) {
	                $('<label><input type="checkbox" name="users[]" value="' + data.users[index].id + '" /><span>' + data.users[index].name + '</span></label>').appendTo(divUsers);
	            }
	            divUsers.prev().removeClass('hide');
	        }

	        divDocuments.empty();
	        if (!data.documents.length) {
	            $('<div class="alert alert-danger" role="alert">' + partnerDocsEmpty + '</div>').appendTo(divDocuments);
	            divDocuments.prev().addClass('hide');
	        } else {
	            for (var index in data.documents) {
	                $('<label><input type="checkbox" name="documents[]" value="' + data.documents[index].id + '" /><span>' + data.documents[index].name + '</span></label>').appendTo(divDocuments);
	            }
	            divDocuments.prev().removeClass('hide');
	        }
        }, 'json');
    });

	if(isManager)
	{
		if(action == 'create')
		{
			selectPartner.val(businessPartner).trigger('change');
		}
		selectPartner.closest('.form-group').addClass('hide');
	}
    
    if((selectPartner.val() != '') && ($('.has-error').length > 0))
    {
	    selectPartner.trigger('change');
    }


    $('.checklist').parent().on('click', '[data-select]', function(){
        $(this).closest('div').next().find('input[type=checkbox]').prop('checked', true);

    }).on('click', '[data-deselect]', function(){
        $(this).closest('div').next().find('input[type=checkbox]').prop('checked', false);
    });

});