<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients_notifications extends MY_Controller {

	var $model = 'notifications_clients_m';
	var $client_id;

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = '';
		$this->main_tip = lang('clients_tip');
	}
	
	function index($client_id)
	{
		$this->load->model('clients_m');
		$client = $this->clients_m->get_one($client_id);
		$this->main_title = $client['name'].' '.$client['surname'];
		$this->add_pre_breadcum('clients', '<i class="fa fa-smile-o"></i> '. lang('menu_clients'));
		$name = strtolower(get_class($this));
		$data = array();
		$data['values'] = $client;
		$data['table_id'] = $name."_table"; 
		$data['toolbar'] = ''; 
		$data['items_source'] = $name.'/table/'.$client_id; 
		$data['items_table'] = $this->_get_items('table');
		$this->show_template('clients_notifications/table', $data);
	}
	
	public function table($client_id)
	{
		$this->client_id = $client_id;
		$this->load->view('output/json', array('json' => $this->_ajax_table()));
	}
	
	function view($id)
	{
		$this->load->model('notifications_m');
		$notification = $this->notifications_m->get_one($id);
		$content = $notification['description'];
		$data['dialog_icon'] = "fa fa-bullhorn";
		$data['dialog_tittle'] = $notification['title'];
		$data['dialog_title_background'] = "bg-green";
		$data['dialog_content'] = $content;
		$extra = $this->load->view('items/dialog_content', $data);
	}
	
	function _callback_row($key, $item, &$rows)
	{
		switch ($key) {
			case 'id':
				$id = $item;
				$item = anchor('#','<i class="fa fa-search"></i> '.lang('notification_view'), 'class="btn btn-success btn-sm" data-toggle="modal" data-target="#dialog_modal" data-href="'.site_url('clients_notifications/view/'.$id).'"');
				break;
		}
		 return $item===NULL? '' : $item; 
	}

	function _callback_filter()
	{
		return "client_id=".$this->client_id;
	}
	
}