<?php
$this->load->model($item['model']);

$data_items = $this->$item['model']->$item['method']($item['params']);

$error_str = form_error($item['field'],'<div>','</div>');
$has_error = false;
if ($error_str!=''){
	$has_error = true;
}
$current_value = $item['value'];
$current_values = explode(',', $current_value);
?>
<div class="form-group<?php echo $has_error ? ' has-error' : '' ; ?>">
	<label for="<?php echo $item['field']; ?>">
		<?php echo $item['label']; ?>
		<?php if($has_error){ ?>
			<i class="fa fa-times-circle-o"></i>
		<?php } ?>
	</label>
	
	<input type="hidden" id="<?php echo $item['field']; ?>"  name="<?php echo $item['field']; ?>" placeholder="<?php echo $item['label']; ?>" class="form-control" value="<?php echo htmlspecialchars($current_value); ?>"></input>
	
	<div class="row" id="<?php echo $item['field']; ?>_add_list">
		<div class="col-md-6">
			<label>Asignados</label>
			<div class="select_list">
				<ol class="assigned">
					<?php 
					$count = 0;
					foreach($current_values as $current_val){
						foreach($data_items as $data_item){ 
							if($data_item['value'] == $current_val){ ?>
								<li value="<?php echo $data_item['value']; ?>"><?php echo $data_item['text']; ?></li>
					<?php 		$count ++;
								break;
							}
						}
					}
					if($count == 0){ 
					?>
						<li class="placeholder">Añade elementos arrastrándolos desde el listado de "Disponibles"</li>
					<?php } ?>
				</ol>
			</div>
		</div>
		<div class="col-md-6">
			<label>Disponibles</label>
			<div class="select_list">
				<ul class="avaliable">
					<?php foreach($data_items as $data_item){ ?>
						<li value="<?php echo $data_item['value']; ?>"><?php echo $data_item['text']; ?></li>
					<?php } ?>
				</ul>
			</div>
		</div>
	</div>
	<script>
	$(function() {
		$( "#<?php echo $item['field']; ?>_add_list .avaliable li" ).draggable({
			appendTo: "body",
			helper: "clone"
		});
		$( "#<?php echo $item['field']; ?>_add_list .assigned" ).droppable({
				activeClass: "ui-state-default",
				hoverClass: "ui-state-hover",
				accept: ":not(.ui-sortable-helper)",
				drop: function( event, ui ) {
					$( this ).find( ".placeholder" ).remove();
					$( "<li></li>" ).text( ui.draggable.text() ).attr("value", ui.draggable.attr('value') ).appendTo( this );
					update_input();
				}
			}).sortable({
				items: "li:not(.placeholder)",
				sort: function() {
					$(this).removeClass( "ui-state-default" );
					update_input();
				}
		});
		function update_input(){
			var values = [];
			$( "#<?php echo $item['field']; ?>_add_list .assigned li" ).each(function(index) {
				if($(this).attr("value") > 0){
					values.push($(this).attr("value"));
				}
			});
			var input_elem = $("#<?php echo $item['field']; ?>");
			$(input_elem).val(values.join(','));
		}
	});
	</script>
</div>