<?php
$error_str = form_error($item['field'],'<remove>','<remove>');
$error_str = str_ireplace('<remove>', '', $error_str);
$has_error = false;
if ($error_str!=''){
	$has_error = true;
}
?>
<div class="form-group<?php echo $has_error ? ' has-error' : '' ; ?>">
	<label id="<?php echo $item['field']; ?>_label" for="<?php echo $item['field']; ?>_upload"
		<?php if($has_error){ ?>data-toggle="tooltip" data-placement="top" title="<?php echo $error_str; ?>" <?php } ?>
		>
		<?php echo $item['label']; ?>
		<?php if($has_error){ ?>
			<i class="fa fa-times-circle-o"></i>
		<?php } ?>
	</label>
	<?php if(isset($item['help'])){ ?>
	<button id="<?php echo $item['field'].'_pop'; ?>" 
		type="button" 
		class="btn btn-xs btn-default popover-dismiss pull-right" 
		data-toggle="popover" 
		data-placement="left" 
		title="<?php echo lang('help_contextual'); ?>" 
		data-content="<?php echo $item['help']; ?>"><i class="fa fa-question"></i></button>
	<script type="text/javascript">
		$(document).ready(function(){
		    $("#<?php echo $item['field'].'_pop'; ?>").popover({trigger: 'focus'});
		});
	</script>
	<?php } ?>
		<div id="<?php echo $item['field'].'_view'; ?>">
		<?php if(isset($item['filetype']) && $item['filetype'] == 'image'){ ?>	
			<?php if(empty($item['value'])){ ?>
				<?php echo lang('no_image_selected'); ?>
			<?php }else{ ?>
				<img src="<?php echo site_url('uploader/view/'.$item['dir'].$item['value']); ?>" id="<?php echo $item['field'].'_image'; ?>" >
				<div class="preview-pane" id="<?php echo $item['field'].'_preview'; ?>">
					<div class="preview-container">
				    	<img src="<?php echo site_url('uploader/view/'.$item['dir'].$item['value']); ?>" class="jcrop-preview" alt="Preview" />
				   	</div>
				</div>
			<?php } ?>
			<script type="text/javascript">
				var jcrop_api,
				        boundx,
				        boundy,
				  		
				        $preview,
				        $pcnt,
				        $pimg,
				
				        xsize,
				        ysize;
				  jQuery(function($){
					init_crop_<?php echo $item['field']; ?>();
				  });
				  
				  function init_crop_<?php echo $item['field']; ?>()
				  {
				        // Grab some information about the preview pane
				        $preview = $('#<?php echo $item['field'].'_preview'; ?>');
				        $pcnt = $('#<?php echo $item['field'].'_preview'; ?> .preview-container');
				        $pimg = $('#<?php echo $item['field'].'_preview'; ?> .preview-container img');
				
				        xsize = $pcnt.width();
				        ysize = $pcnt.height();
				    
				    $('#<?php echo $item['field'].'_image'; ?>').Jcrop({
				      onChange: updatePreview<?php echo $item['field']; ?>,
				      onSelect: updatePreview<?php echo $item['field']; ?>,
				      aspectRatio: xsize / ysize
				    },function(){
				      // Use the API to get the real image size
				      var bounds = this.getBounds();
				      boundx = bounds[0];
				      boundy = bounds[1];
				      // Store the API in the jcrop_api variable
				      jcrop_api = this;
				
				      // Move the preview into the jcrop container for css positioning
				      $preview.appendTo(jcrop_api.ui.holder);
				      
				      
				      var init_c = {w:boundx, h:boundy, x:0, y:0}; 
				      console.log(init_c)
				      updatePreview<?php echo $item['field']; ?>(init_c);
				    });
				  }
				  
				  function updatePreview<?php echo $item['field']; ?>(c)
				    {
				      if (parseInt(c.w) > 0)
				      {
				        var rx = xsize / c.w;
				        var ry = ysize / c.h;
				
				        $pimg.css({
				          width: Math.round(rx * boundx) + 'px',
				          height: Math.round(ry * boundy) + 'px',
				          marginLeft: '-' + Math.round(rx * c.x) + 'px',
				          marginTop: '-' + Math.round(ry * c.y) + 'px'
				        });
				      }
				    };
				</script>
				
				<style type="text/css">

				/* Apply these styles only when #preview-pane has
				   been placed within the Jcrop widget */
				.jcrop-holder .preview-pane {
				  display: block;
				  position: absolute;
				  z-index: 2000;
				  top: 10px;
				  right: -220px;
				  padding: 6px;
				  border: 1px rgba(0,0,0,.4) solid;
				  background-color: white;
				
				  -webkit-border-radius: 6px;
				  -moz-border-radius: 6px;
				  border-radius: 6px;
				
				  -webkit-box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
				  -moz-box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
				  box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
				}
				
				/* The Javascript code will set the aspect ratio of the crop
				   area based on the size of the thumbnail preview,
				   specified here */
				.preview-pane .preview-container {
				  width: 170px;
				  height: 170px;
				  overflow: hidden;
				}
				
				</style>
			
		<?php }else{ ?>
			<?php if(empty($item['value'])){ ?>
				<?php echo lang('no_file_selected'); ?>
			<?php }else{ ?>
				<?php echo anchor('uploader/view/'.$item['dir'].$item['value'], 'Ver fichero seleccionado...', array('target' => '_blank')); ?>
			<?php } ?>
		<?php } ?>
		</div>
		<input 
			type="file" 
			id="<?php echo $item['field'].'_upload'; ?>" 
			name="<?php echo $item['field'].'_upload'; ?>">
		<input
			type="hidden" 
			id="<?php echo $item['field']; ?>" 
			name="<?php echo $item['field']; ?>" 
			value="<?php echo $item['value']; ?>" />
	<?php if($has_error){?>
	<script type="text/javascript">
		$(document).ready(function(){
		    $('#<?php echo $item['field']; ?>_label').tooltip({template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow text-red"></div><div class="tooltip-inner bg-red"></div></div>'});
		});
	</script>
	<?php } ?>
	<script type="text/javascript">
    $(function() {
        $('#<?php echo $item['field'].'_upload'; ?>').uploadify({
        	'method'   : 'post',
        	'multi' : false,
        	'buttonText' : '<i class="fa fa-paperclip"></i> Load file',
        	<?php if(isset($item['filetype']) && $item['filetype'] == 'image'){ ?>
        	'fileTypeDesc' : 'Images',
        	'fileTypeExts' : '*.gif; *.jpg; *.jpeg; *.png;',
        	<?php }else{ ?>
        	'fileTypeDesc' : 'Documents Files',
        	'fileTypeExts' : '*.gif; *.jpg; *.jpeg; *.png; *.doc; *.docx; *.pdf',
        	<?php } ?>
            'swf'      : '<?php echo base_url('plugins/uploadify/uploadify.swf'); ?>',
            'uploader' : '<?php echo site_url('uploader'); ?>',
            'onUploadSuccess' : function(file, data, response) {
            	$('#<?php echo $item['field']; ?>').val('[#POOL#]'+data);
            	<?php if(isset($item['filetype']) && $item['filetype'] == 'image'){ ?>
            		$('#<?php echo $item['field'].'_view'; ?>').html('<img src="<?php echo site_url('uploader/view/pool'); ?>/'+data+'">');
            	<?php }else{ ?>
            	$('#<?php echo $item['field'].'_view'; ?>').html('<a href="<?php echo site_url('uploader/view/pool'); ?>/'+data+'" target="_blank"><?php echo lang('view_selected_file'); ?></a>');
		    	<?php } ?>
		    }
        });
    });
    </script>
</div>