//
//  DocsViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 17/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import Kingfisher

private let reuseIdentifier = "docCell"

class DocsViewController: UIViewController, UICollectionViewDataSource, UICollectionViewDelegate, UIGestureRecognizerDelegate  {
    
    var userTreeArray = [DocsCategoriesDemo]()
    var repoTreeArray = [DocsCategoriesDemo]()
    var menuTreesArray = [DocsCategoriesDemo]()
    var documentWithoutCategoryArray = [DocumentObject]()
    var hasMenu : Bool?
    var treeToShow : String?
    var docsCategory : DocsCategoriesDemo?
    var partnerships : String?
    var numberOfItems : Int?
    var docCell : DocCollectionViewCell?
    var userObs : userObject?
    var urlManagers : URLBaseManager?
    var docsCategoriesDemo : DocsCategoriesDemo?
     var brandInf : BrandingInfo?
    @IBOutlet weak var docsCollectionView: UICollectionView!
    
    
     func settingBrandingInfo() {
        
        
        brandInf = self.userObs?.partnerI?.brandInf
        
        if let brand = brandInf
        {
            
            self.view.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
            docsCollectionView.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
        }
        
    }

    
    override func viewWillAppear(animated: Bool) {
        
        super.viewWillAppear(animated)
        
        
        
        let logOutGestureLeft : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureLeft.direction = UISwipeGestureRecognizerDirection.Left
        self.view.addGestureRecognizer(logOutGestureLeft)
        
        let logOutGestureRight : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureRight.direction = UISwipeGestureRecognizerDirection.Right
        self.view.addGestureRecognizer(logOutGestureRight)
        
    }
    
    
    
    func backToMainMenu()
    {
        self.userTreeArray.removeAll()
        self.repoTreeArray.removeAll()
        self.dismissViewControllerAnimated(true, completion: nil)
        
    }
    

    override func viewDidLoad() {
        super.viewDidLoad()
        
        settingBrandingInfo()
        urlManagers = URLBaseManager.sharedInstance

        // Do any additional setup after loading the view.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
    
    //Mark Delegate and DataSource from CollectionView
    
    
    func numberOfSectionsInCollectionView(collectionView: UICollectionView) -> Int {
        
        return 1
    }
    
    func collectionView(collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        
        if treeToShow == "userTree"
        {
            if (self.userTreeArray.count > 0)
            {
                numberOfItems = self.userTreeArray.count
            }
            
        }
        
        if treeToShow == "repoTree"
        {
            if (self.repoTreeArray.count > 0)
            {
                numberOfItems = self.repoTreeArray.count
            }
            
        }
        
        return numberOfItems!
        
    }
    
    
    
    func collectionView(collectionView: UICollectionView, cellForItemAtIndexPath indexPath: NSIndexPath) -> UICollectionViewCell
    {
        
        docCell = collectionView.dequeueReusableCellWithReuseIdentifier(reuseIdentifier, forIndexPath: indexPath) as? DocCollectionViewCell
        
        if self.hasMenu == true
        {
            if self.treeToShow == "userTree"
            {
                if self.userTreeArray.count > 0
                {
                    self.docsCategoriesDemo = self.userTreeArray[indexPath.row]
                    docsCategoryGeneration()
                }
            }
            
            if self.treeToShow == "repoTree"
            {
                if self.repoTreeArray.count > 0
                {
                    self.docsCategoriesDemo = self.repoTreeArray[indexPath.row]
                    docsCategoryGeneration()
                }
            }
            
            if self.treeToShow == "Uncategorized"
            {
                
            }
        }
        else
        {
            if self.userTreeArray.count > 0
            {
                self.docsCategoriesDemo = self.userTreeArray[indexPath.row]
                docsCategoryGeneration()
            }
            
            if self.repoTreeArray.count > 0
            {
                self.docsCategoriesDemo = self.repoTreeArray[indexPath.row]
                docsCategoryGeneration()
            
            }
        
        }
        
        
        return docCell!
        
    }
    
    func docsCategoryGeneration()
    {
        docCell?.docLabel.text = self.docsCategoriesDemo?.categoryName

        //docCell?.docImage.kf_setImageWithURL(getDocsImages((self.docsCategoriesDemo?.itemId!)!), placeholderImage: nil)
        
        docCell?.docImage.kf_setImageWithURL(getDocsImages((self.docsCategoriesDemo?.itemId!)!), placeholderImage: UIImage(named: ""), optionsInfo: [.Options(KingfisherOptions.CacheMemoryOnly)])
        
        //self.serviceCell?.serviceImage.kf_setImageWithURL(NSURL(string: (self.user?.container?.smartImage)! as String)!, placeholderImage: UIImage(named: ""), optionsInfo:[.Options(KingfisherOptions.CacheMemoryOnly)])      
        
        
        
        if let brand = brandInf
        {
            docCell?.backgroundColor = UIColor(colorLiteralRed: Float(brand.colorServiceArray[0])/255, green: Float(brand.colorServiceArray[1])/255, blue: Float(brand.colorServiceArray[2])/255, alpha: 1.0)
            docCell?.docLabel.textColor = UIColor(colorLiteralRed: Float(brand.fontColorService[0])/255, green: Float(brand.fontColorService[1])/255, blue: Float(brand.fontColorService[2])/255, alpha: 1.0)
        }
    }
    
    func getDocsImages(catDocId: String)->NSURL
    {
        let urlString  = "\((urlManagers?.DocumentImageURL)!)access_token=\((NSUserDefaults.init().objectForKey("token"))!)&item_id=\(catDocId)"
        let url = NSURL(string: urlString)
        return url!
    }
    
    func subDocsGeneration()
    {
        self.performSegueWithIdentifier("subDocMenuSegue", sender: self)
    }
    
    func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        
        if self.hasMenu == true
        {
            if self.treeToShow == "userTree"
            {
                
                if self.userTreeArray.count > 0
                {
                    
                    
                    self.docsCategoriesDemo = self.userTreeArray[indexPath.row]
                     subDocsGeneration()
                }
            }
            
            if self.treeToShow == "repoTree"
            {
                if self.repoTreeArray.count > 0
                {
                    self.docsCategoriesDemo = self.repoTreeArray[indexPath.row]
                    subDocsGeneration()
                }
            }
            
           
        }
        else
        {
            if self.userTreeArray.count > 0
            {
                self.docsCategoriesDemo = self.userTreeArray[indexPath.row]
                subDocsGeneration()
            }
            
            if self.repoTreeArray.count > 0
            {
                self.docsCategoriesDemo = self.repoTreeArray[indexPath.row]
                subDocsGeneration()
                
            }
                        
        }
        

    }
    
    
    
    
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        
        if segue.identifier == "subDocMenuSegue"
        {
            let subDocVC = segue.destinationViewController as! SubDocMenuViewController
            subDocVC.docsCats = self.docsCategoriesDemo
            subDocVC.userObss = self.userObs
            subDocVC.partnerShipss = self.partnerships!
            
            if self.docsCategoriesDemo?.categoryName == "Uncategorized"
            {
                subDocVC.treeShows = "Uncategorized"
            
            }
            else
            {
                subDocVC.treeShows = self.treeToShow
            }
            
            debugPrint(subDocVC.treeShows)
            debugPrint(self.partnerships!)
            debugPrint(self.docsCategoriesDemo?.doctumentWithoutCategoryArray.count)
            
        }
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    

}
