//
//  PartnerSelectorViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 8/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit

class PartnerSelectorViewController: UIViewController, UIPickerViewDelegate, UIPickerViewDataSource {
    
    var partners : Array<String>!

    var titlePartner : String?
    
    @IBOutlet weak var partnerLabel: UILabel!
    
    @IBOutlet weak var partnerSelector: UIPickerView!
    
    @IBOutlet weak var partnerButton: UIButton!
    
    @IBAction func loginScreen(sender: AnyObject) {
        
        if (titlePartner != nil)
        {
        
            dispatch_async(dispatch_get_main_queue()) {
            
                self.performSegueWithIdentifier("loginScreenSegue", sender: self)
            
            }
        }
       
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        
        partners = ["Limmat", "Lindau", "Lupenrein"]
        self.partnerSelector.delegate = self
        self.partnerSelector.dataSource = self

        // Do any additional setup after loading the view.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
// delegate methods
    
    func numberOfComponentsInPickerView(pickerView: UIPickerView) -> Int {
        
        return 1
    }
    
    func pickerView(pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        
        return partners.count
    }
    
    func pickerView(pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        
         titlePartner = partners[row] as String
        
        
        if let partner = titlePartner
        {
            self.partnerLabel.text = partner
            
            
        }
        
        return titlePartner!
    }
    
    func pickerView(pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int) {
        let partner = partners[row]
        self.partnerLabel.text = partner
    }
    
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        
        if segue.identifier == "loginScreenSegue"
        {
            let loginVC = segue.destinationViewController as? LoginViewController
            loginVC?.partner = titlePartner!
        }
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    

}
