//
//  SubMainMenuViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 10/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import Kingfisher

class SubMainMenuViewController: MainMenuViewController {

    var partnership : String?
    var subServiceCell : subServiceCollectionViewCell?
    var arrayOfSubServices = NSMutableArray()
    var subService : ServiceObject?
    
    override func settingBrandingInfo() {
        super.settingBrandingInfo()
        
        brandInf = self.user?.partnerI?.brandInf
        
        if let brand = brandInf
        {
            
            self.view.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
            collectionView.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
        }

    }
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        settingBrandingInfo()
        
        let logOutGestureLeft : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureLeft.direction = UISwipeGestureRecognizerDirection.Left
        self.view.addGestureRecognizer(logOutGestureLeft)
        
        let logOutGestureRight : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureRight.direction = UISwipeGestureRecognizerDirection.Right
        self.view.addGestureRecognizer(logOutGestureRight)
        
        // Do any additional setup after loading the view.
    }

    
    func backToMainMenu()
    {
        self.dismissViewControllerAnimated(true, completion: nil)
    }
    
    override func viewDidDisappear(animated: Bool) {
        super.viewDidDisappear(animated)
        
        self.serviceCell = nil
        collectionView = nil
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    override func numberOfSectionsInCollectionView(collectionView: UICollectionView) -> Int {
        
        return 1
    }
    
    override func collectionView(collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        let count: Int = (self.arrayOfSubServices.count)
        
        print(count)
        return count
        
    }
    
    
    
    override func collectionView(collectionView: UICollectionView, cellForItemAtIndexPath indexPath: NSIndexPath) -> UICollectionViewCell
    {
        
        if let container = self.arrayOfSubServices[indexPath.row] as? ServiceObject
        {
            
            self.subServiceCell = collectionView.dequeueReusableCellWithReuseIdentifier("subServiceCell", forIndexPath: indexPath) as? subServiceCollectionViewCell
            self.subServiceCell?.subServiceLabel?.text = container.name
            self.subServiceCell?.subServiceImage.kf_setImageWithURL(NSURL(string: container.smartImage! as String)!, placeholderImage: UIImage(named: ""), optionsInfo:[.Options(KingfisherOptions.CacheMemoryOnly)])
            
            
            if let brand = brandInf
            {
                
                self.subServiceCell!.backgroundColor = UIColor(colorLiteralRed: Float(brand.colorServiceArray[0])/255, green: Float(brand.colorServiceArray[1])/255, blue: Float(brand.colorServiceArray[2])/255, alpha: 1.0)
               debugPrint(Float(brand.colorServiceArray[0])/255,Float(brand.colorServiceArray[1])/255,Float(brand.colorServiceArray[2])/255)
                self.subServiceCell?.subServiceLabel.textColor = UIColor(colorLiteralRed: Float(brand.fontColorService[0])/255, green: Float(brand.fontColorService[1])/255, blue: Float(brand.fontColorService[2])/255, alpha: 1.0)
                
                
            }
            
       
            
        }
        
        return subServiceCell!
        
        
    }
    
    override func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        
        
        self.subService = self.arrayOfSubServices[indexPath.row] as? ServiceObject
        
        
        let tyopeOfService = subService?.type
        
       typeOfServices(tyopeOfService!)
        
    }
    
    // MARK: - Selection
    
    override func typeOfServices(typeOfService: Int)
    {
        
        switch typeOfService
        {
        case 1:
            
            
            if let native = self.user?.container?.service?.identifier
            {
                typeOfNativeService(native)
            }
            
            
            break
            
            
            
        case 2:
            
            self.performSegueWithIdentifier("webSegue", sender: self)
            
            break
            
        case 3:
            
            self.performSegueWithIdentifier("marketingSegue", sender: self)
            
            break
            
        case 5:
            
            self.performSegueWithIdentifier("webSegue", sender: self)
            
            break
            
        case 6:
            
            self.performSegueWithIdentifier("webSegue", sender: self)
            break
            
            
            
        default :
            
            
            break
            
        }

        
        
    }
    
    override func typeOfNativeService(nativeService: Int)
    {
       
        switch nativeService
        {
            
        case 1:
            break
        case 2:
            break
        case 3:
            break
        case 4:
            break
        case 5:
            break
        case 6:
            break
        case 7:
            break
        case 8:
            break
        case 9:
            break
        case 10:
            break
        case 11:
            break
        case 12:
            break
        case 13:
            break
        case 14:
            break
        case 15:
            break
        case 16:
            break
        case 17:
            break
        case 18:
            break
        case 19:
            break
        case 20:
            break
        case 21:
            break
        case 22:
            break
        case 23:
            break
        case 24:
            break
        case 25:
            break
        case 26:
            break
        case 27:
            break
        case 28:
            break
        case 29:
            break
        case 30:
            break
        case 31:
            break
        case 32:
            break
        case 53:
            break
        default:
            break
            
        }

        
    }
    
    
    override func categoryService()
    {
        if let active = self.user?.container?.category?.active
        {
            if active != 0
            {
                if let subServices = self.user?.container?.category?.arrayOfSubservices
                {
                    if (subServices.count >= 1 && subServices.count < 2)
                    {
                        
                        for  var i : Int = 0 ; i < subServices.count ; i++
                        {
                            
                            self.user?.container?.service = subServices[i] as? ServiceObject
                            
                            let serviceType = self.user?.container?.service?.type
                            
                            typeOfServices(serviceType!)
                            
                        }
                    }
                    else
                    {
                        self.performSegueWithIdentifier("subMenuSegue", sender: self)
                    }
                }
                
            }
        }
        
    }
    
    override func typeOfCategories(category: Int)
    {
        switch category
        {
            
        case 1:
            categoryService()
            break
        case 2:
            categoryService()
            break
        case 3:
            categoryService()
            break
        case 4:
            categoryService()
            break
        case 5:
            categoryService()
            break
        case 6:
            categoryService()
            break
        case 7:
            categoryService()
            break
        case 8:
            categoryService()
            break
        case 9:
            categoryService()
            break
        case 10:
            categoryService()
            break
        case 11:
            categoryService()
            break
        case 12:
            categoryService()
            break
        case 13:
            categoryService()
            break
        case 14:
            categoryService()
            break
        case 15:
            categoryService()
            break
        case 16:
            categoryService()
            break
        case 17:
            categoryService()
            break
        case 18:
            categoryService()
            break
        case 19:
            categoryService()
            break
        case 20:
            categoryService()
            break
        case 21:
            categoryService()
            break
        case 22:
            categoryService()
            break
        case 23:
            categoryService()
            break
        case 24:
            categoryService()
            break
        case 25:
            categoryService()
            break
        case 26:
            categoryService()
            break
        case 27:
            categoryService()
            break
        case 28:
            categoryService()
            break
        case 29:
            categoryService()
            break
        case 30:
            categoryService()
            break
        case 31:
            categoryService()
            break
        case 32:
            categoryService()
            break
        case 33:
            categoryService()
            break
        case 34:
            categoryService()
            break
        case 35:
            categoryService()
            break
        case 36:
            categoryService()
            break
        case 37:
            categoryService()
            break
        case 38:
            categoryService()
            break
        case 39:
            categoryService()
            break
        case 40:
            categoryService()
            break
        default:
            break
            
        }
        
        
    }
    


    
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        if segue.identifier == "webSegue"
        {
            let webVC = segue.destinationViewController as! WebViewController
            webVC.partner = self.partnership
            if let url = self.subService?.apiURL
            {
                webVC.webURL =  url
                
            }
           
            
        }
               if segue.identifier == "marketingSegue"
        {
            let marketVC = segue.destinationViewController as! MarketingVC
            marketVC.user = self.user
            marketVC.partner = self.partner
            
            if let url = self.subService?.apiURL
            {
                marketVC.youTubeURL =  url
                
            }
             
            
        }

    }
    

}
