//
//  URLBaseManager.swift
//  Lupenrein
//
//  Created by Carlos Fernandez López on 7/1/16.
//  Copyright © 2016 streamnow. All rights reserved.
//

import UIKit
import Alamofire
import SwiftyJSON


private let baseURL: String = "http://route.livingservices.com/getURL?"

class URLBaseManager: NSObject {
    
    // Properties
    var urlObject : URLObject?
    var releaseManager : ReleaseManager?
    var LoginURL: String? //"https://esb-dev.livingservices.com/auth/login"
    var LogOutURL : String?// = "https://esb-dev.livingservices.com/logout"
    var ContactURL : String?// = "https://esb-dev.livingservices.com/getContact?"
    var ContactAvatarURL : String?// = "https://esb-dev.livingservices.com/getContactAvatar?"
    var DocumentsURL : String?// = "https://esb-dev.livingservices.com/getDocsInfo?"
    var DocumentURL : String?// = "https://esb-dev.livingservices.com/getDocInfo?"
    var DocumentImageURL : String?// = "https://esb-dev.livingservices.com/getImage?"
    
    static let sharedInstance = URLBaseManager()
    
    override init() {
        super.init()
       
        let defaults = NSUserDefaults.standardUserDefaults()
        if let name = defaults.stringForKey("partner")
        {
            releaseManager = ReleaseManager(initWithPartner: name)
            debugPrint(releaseManager?.appIdAPN)
            getBaseURL(baseURL, appID: (releaseManager?.appIdAPN)!)
        }
    
        
        
    }
    
    func setURLs(bodyURL:String)
    {
       self.LoginURL = "\(bodyURL)auth/login"
       self.LogOutURL = "\(bodyURL)logout"
       self.ContactURL = "\(bodyURL)getContact?"
        self.ContactAvatarURL = "\(bodyURL)getContactAvatar?"
        self.DocumentsURL = "\(bodyURL)getDocsInfo?"
        self.DocumentURL = "\(bodyURL)getDocInfo?"
        self.DocumentImageURL = "\(bodyURL)getImage?"
    }
    
    func getBaseURL(body: String, appID : String)
    {
       let requestURL : NSURL = NSURL(string: "\(body)app=\(appID)")!
        debugPrint(requestURL)
        
        Alamofire.request(.GET, requestURL)
            
            .responseJSON { response in
                print(response.request)  // original URL request
                print(response.response) // URL response
                print(response.data)     // server data
                print(response.result)   // result of response serialization
                
                if let _ = response.result.value {
                    
                    let json = JSON(data: response.data!)
                    
                    self.urlObject = URLObject(jsonDictionary: json)
                    
                    if let urlString = self.urlObject?.url
                    {
                        self.setURLs(urlString)
                    }
                    
                    
                    debugPrint(json, terminator: "")
                    
                    
                }
                else
                {
                    NSNotificationCenter.defaultCenter().postNotificationName("urlError", object: nil)
                }
        }

    }

}
