//
//  userObject.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 19/10/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import SwiftyJSON
import Foundation

class userObject: NSObject {
    
    var canLogIn: Bool?
    var name : String?
    var username: String?
    var mail : String?
    var telephone : String?
    var mobile : String?
    var userID : String?
    var gender : String?
    var lastName : String?
    var paymentAllowed : String?
    var userSecretId : String?
    var accessToken : String?
    var refreshToken : String?
    var urlImage : String?
    var availableServices : NSMutableArray?
    var suscribedServices : NSMutableArray?
    var categoriesArray : NSMutableArray?
    var availableCategories : NSMutableArray?
    var listOfServices : NSMutableArray?
    var container : ContainerObject?
    var category : CategoryObject?
    var subservice : SubServiceObject?
    var partnerI : PartnerInfo?
    
    //Partner Branding
    
    
    
    
    init(jsonDictionary: JSON) {
        
        super.init()
        
        self.availableServices = NSMutableArray()
        self.suscribedServices = NSMutableArray()
        self.availableCategories = NSMutableArray()
        self.listOfServices = NSMutableArray()
        
        
        let subServicisIdentifier: NSMutableArray = NSMutableArray()
        let categoriesIdentifier : NSMutableArray = NSMutableArray()
        let availableServices = jsonDictionary["available_services"]
        
        
        
     
        
        if let responseArray = jsonDictionary["available_services"].array
        {
            for Dictionary in responseArray
            {
                self.container = ContainerObject.init(jsonDictionary: Dictionary, typeOfContainer: "service")
                self.listOfServices?.addObject(self.container!)
                
                if (container?.identifier == 0 && (container?.usable != 0))
                {
            
                         self.availableServices?.addObject(self.container!)
                    
                }
                else if(self.container?.usable != 0)
                {
                    self.suscribedServices?.addObject((self.container?.service)!)
                    subServicisIdentifier.addObject((self.container?.service?.categoryId)!)
                }
                
                /*
                if (container?.identifier == 0 && container?.usable != nil)
                {
                
                }
*/
                
            }
            debugPrint(self.availableServices?.count)
        }
        
        
        if let responseCategories = jsonDictionary["categories"].array
        {
            for Dictionary in responseCategories
            {
                self.container = ContainerObject.init(jsonDictionary: Dictionary, typeOfContainer: "category")
                debugPrint(self.container?.active!)
                
                if(self.container?.active != 0)
                {
                    self.availableServices?.addObject(self.container!)
                    self.availableCategories?.addObject((self.container?.category)!)
                     categoriesIdentifier.addObject((self.container?.category?.categoryId)!)
                    //categoriesIdentifier.addObject((self.container?.category?.categoryId)!)
                    
                }
            }
            debugPrint(self.availableServices?.count)
        }
        else
        {
            NSNotificationCenter.defaultCenter().postNotificationName("wrongLogin", object: self)
        }
        
        
        for var i = 0; i < subServicisIdentifier.count; i++
        {
            self.container?.service?.categoryId = (subServicisIdentifier.objectAtIndex(i)) as? Int
            
            self.container?.service = self.suscribedServices?.objectAtIndex(i) as? ServiceObject
            
            
            for var a = 0; a < self.availableCategories?.count; a++
            {
                self.container?.category = self.availableCategories?.objectAtIndex(a) as? CategoryObject
                self.container?.category?.categoryId = categoriesIdentifier.objectAtIndex(a) as? Int
                
                if self.container?.service?.categoryId == self.container?.category?.categoryId
                {
                    self.container?.category?.arrayOfSubservices?.addObject((self.container?.service)!)
                }
                
            }
        }

        
        self.accessToken = jsonDictionary["access_token"].string
        NSUserDefaults.init().setObject(self.accessToken, forKey: "token")
        debugPrint(self.accessToken, terminator: "")
        self.refreshToken = jsonDictionary["refresh_token"].string
        
        
        if let responseArray = jsonDictionary["user_info"].dictionary
        {
            
            if let partnerArray = responseArray["partner"]?.dictionary
            {
                
                   partnerI = PartnerInfo(jsonDictionary: partnerArray)
            
                   debugPrint(partnerI?.partnerName)
                

            
            }
            
            
        }
        
        
        if self.accessToken?.length > 0 && availableServices.count > 0
        {
            NSNotificationCenter.defaultCenter().postNotificationName("successLog", object:nil)
        
            
            NSLog("SuccessLog")
        
        }
        else
        {
            
        }
        
        
        
        
        
        
    }
    

}
