<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

$config['table'] = array(
			array(
				'field'   => 'image',
				'label'   => lang('field_image')
			),
			array(
				'field'   => 'fullname',
				'label'   => lang('field_name')
			),
			array(
				'field'   => 'user',
				'label'   => lang('field_user')
			),
			array(
				'field'   => 'id',
				'label'   => lang('actions')
			)
		);
		
$config['create'] = array(
			'fullname' => array(
				'field' => 'fullname',
				'label' => lang('field_fullname'),
				'rules' => ''
			),
			'image' => array(
				'field' => 'image',
				'label' => lang('field_image'),
				'type'  => "file",
				'filetype' => 'image',
				'dir'   => 'avatar',
				'rules' => 'required'
			),
			'user' => array(
				'field' => 'user',
				'label' => lang('field_user'),
				'rules' => 'required|is_unique[admin.user]'
			),
			'password' => array(
				'field' => 'password',
				'label' => lang('field_password'),
				'type'  => "password"
			),
			'language' => array(
				'field' => 'language_id',
				'label' => lang('field_language'),
				'type' => 'select',
				'rules' => 'required',
				'model' => 'languages_m',
				'method' => 'get_languages',
			),
		);
		
$config['edit'] = $config['create'];
unset($config['edit']['user']);
