<?php
 /**
  * Controller for Business partners
  *
  * This is the controller used to Business partners section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Business_partners - Controller
  *
  * Controller for Business partners section.
  */
class Business_partners extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'business_partners_m';

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-users';
		$this->main_title = lang('menu_business_partners');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table();
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column 
	  * @param mixed $value Value 
	  * @param array $row Array containing all row data 
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$row){
	
		switch($key)
		{
			case 'id':
				$value				= anchor('business_partners/edit/'.$row->id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
				break;
			case 'default_image':
			case 'default_document_image':
			case 'general_image':
			case 'general_document_image':
				$value				= '<img src="'.site_url('uploader/view/business_partners'.$value).'" style="display:block; margin:0 auto; border-radius: 50%; width: 50px; height: 50px;" alt="Project '.ucfirst(str_replace('_', ' ', $key)).'">';
				break;
		}
		 return $value === NULL ? '' : $value; 
	}
}