<?php
 /**
  * Controller for Clients
  *
  * This is the controller used to Clients section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients - Controller
  *
  * Controller for Clients section.
  */
class Clients extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model			= 'clients_m';
	/** @var string This is the edit message to the section. */
	var $edit_view 		= 'clients/edit';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->icon			= 'fa fa-smile-o';
		$this->main_tip		= lang('clients_tip');
		$this->main_title	= lang('menu_clients');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table();
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column
	  * @param mixed $value Value
	  * @param array $row Array containing all row data
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$row)
	{
		switch($key)
		{
			case 'id':
				$id					= $value;
				$value				= '<a href="clients_repo/index/'.$id.'" id="document-'.$id.'" data-value="'.$id.'" class="btn btn-success btn-sm"><i class="fa fa-book"></i>'.lang('docs').'</a>';
				break;
		}

		return $value === NULL ? '' : $value;
	}
}