<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifications extends MY_Controller {

	var $model = 'notifications_m';

	function __construct()
	{
		parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = lang('menu_notifications');
		$this->main_tip = lang('notifications_tip');
	}

	/**
	  * Return layout view for table section of crud.
	  */
	function index()
	{
		$this->_table();
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column 
	  * @param mixed $value Value 
	  * @param array $row Array containing all row data 
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$rows){
		switch($key)
		{
			case 'id':
				$id					= $value;

				$item				= anchor('notifications/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
				$item				.= "&nbsp;"; 
				$item				.= anchor('notifications/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');
				break;
		}

		return $value === NULL ? '' : $value; 
	}
}