<?php
 /**
  * Controller for Clients Categories
  *
  * This is the controller used to Clients Repo section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients_repo - Controller
  *
  * Controller for Clients repo section.
  */
class Clients_repo extends MY_Controller {

	var $model = '';

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-book';
		$this->main_title = lang('menu_repo');
		$this->main_tip = lang('clients_repo_tip');
	}

	public function _tree($content = NULL, $client_id)
	{
		$name = strtolower(get_class($this));
		$data = array();
		$data['tree_id'] = $name."_tree";
		$this->load->model('clients_m');
		$data['values'] = $this->clients_m->get_one($client_id);
		$data['tree_source'] = $name."/tree_source/".$client_id;
		$data['tree_panel'] = $name."/tree_panel/".$client_id;
		$data['tree_content'] = $content;
		$this->show_template('clients_repo/tree', $data);
	}

	function index($client_id)
	{
		$this->load->model('clients_m');
		$client = $this->clients_m->get_one($client_id);
		$this->main_title = $client['name'].' '.$client['surname'];
		$this->add_pre_breadcum('clients', '<i class="fa fa-smile-o"></i> '. lang('menu_clients'));
		$this->_tree($this->tree_panel($client_id), $client_id);
	}

	function tree_source($client_id)
	{
		$id = $this->input->post('id');
		$data = array();
		if($id=='#'){
			$data[] =  array('id' => 'root',
						'children' => TRUE,
						'text' => lang('repo_root'),
						'icon' => 'fa fa-book',
						'state' => array('opened' => TRUE)
					);
		}
		if($id=='root'){
			$this->load->model('clients_categories_m');
			$cats = $this->clients_categories_m->get_by_parent($client_id, null);
			foreach($cats as $cat){
				$data[] = array('id' => 'c_'.$cat['id'],
								'children' => TRUE,
								'icon' => 'fa fa-folder-open-o',
								'text' => $cat['category_name']);
			}
			$this->load->model('clients_docs_m');
			$docs = $this->clients_docs_m->get_by_category_id($client_id, null);
			foreach($docs as $doc){
				$data[] = array('id' => 'd_'.$doc['id'],
								'children' => FALSE,
								'icon' => 'fa fa-file-o',
								'text' => $doc['name']);
			}
		}
		if(substr($id, 0, 2)=='c_'){
			$id = str_replace('c_', '', $id);
			$this->load->model('clients_categories_m');
			$cats = $this->clients_categories_m->get_by_parent($client_id, $id);
			foreach($cats as $cat){
				$data[] = array('id' => 'c_'.$cat['id'],
								'children' => TRUE,
								'icon' => 'fa fa-folder-open-o',
								'text' => $cat['category_name']);
			}
			$this->load->model('clients_docs_m');
			$docs = $this->clients_docs_m->get_by_category_id($client_id, $id);
			foreach($docs as $doc){
				$data[] = array('id' => 'd_'.$doc['id'],
								'children' => FALSE,
								'icon' => 'fa fa-file-o',
								'text' => $doc['name']);
			}
		}

		$this->load->view('output/json', array('json' =>$data));
	}

	function tree_panel($client_id, $id = NULL)
	{
		if($id==NULL){
			$refresh = FALSE;
			$id = $this->input->post('id');
		}else{
			$refresh = TRUE;
		}
		$item_tree_id = $id;
		$data = array();
		if(!$id){
			$data = $this->_panel_welcome($client_id);
			return $this->load->view('items/box', $data, TRUE);
		}elseif($id=='root'){
			$data = $this->_panel_root($client_id);
		}else{
			switch (substr($id, 0, 2)) {
				case 'c_':
					$id = str_replace('c_', '', $id);
					$data = $this->_panel_category($client_id,$id);
					break;
				case 'd_':
					$id = str_replace('d_', '', $id);
					$data = $this->_panel_document($client_id,$id);
					break;
			}
		}
		$this->load->view('items/box', $data);
		if($refresh){
			$this->load->view('crud/tree_refresh', array('tree_id' => '#clients_repo_tree', 'id' => $item_tree_id));
		}
	}

	function _panel_welcome()
	{
		$data = array();
		$data['box_icon'] = "fa fa-book";
		$data['box_title'] = lang('repo_management');
		$data['box_content'] = $this->load->view('clients_repo/welcome', NULL, TRUE);
		return $data;
	}

	function _panel_root($client_id)
	{
		$data = array();
		$data['box_icon'] = "fa fa-book";
		$data['box_title'] = lang('repo_root');
		$data['box_content'] = $this->load->view('clients_repo/root', NULL, TRUE);
		$data['box_buttons'] = anchor('clients_categories/create/'.$client_id,'<i class="fa fa-folder-o"></i> '.lang('repo_categories_create'), 'class="btn btn-primary btn-sm" target="#clients_repo_tree_content"');
		$data['box_buttons'].= anchor('clients_docs/create/'.$client_id,'<i class="fa fa-file-o"></i> '.lang('repo_docs_create'), 'class="btn btn-primary btn-sm pull-right" target="#clients_repo_tree_content"');
		return $data;
	}

	function _panel_category($client_id, $id)
	{
		$this->load->model('clients_categories_m');
		$cat = $this->clients_categories_m->get_custom_one($id);
		if(empty($cat)){show_404();}
		$data = array();
		$data['box_icon'] = "fa fa-folder-o";
		$data['box_title'] =lang('category')." ".$cat['category_name'];
		$data['box_content'] = $this->load->view('clients_repo/category', $cat, TRUE);
		$data['box_top_buttons'] = anchor('clients_categories/edit/'.$client_id.'/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm" target="#clients_repo_tree_content"');
		$data['box_top_buttons'].= "&nbsp;";
		$data['box_top_buttons'].= anchor('clients_categories/delete/'.$client_id.'/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm" target="#clients_repo_tree_content"');
		$data['box_buttons'] = anchor('clients_categories/create/'.$client_id.'/'.$id,'<i class="fa fa-folder-o"></i> '.lang('repo_categories_create'), 'class="btn btn-primary btn-sm" target="#clients_repo_tree_content"');
		$data['box_buttons'].= anchor('clients_docs/create/'.$client_id.'/'.$id,'<i class="fa fa-file-o"></i> '.lang('repo_docs_create'), 'class="btn btn-primary btn-sm pull-right" target="#clients_repo_tree_content"');
		return $data;
	}

	function _panel_document($client_id, $id)
	{
		$this->load->model('clients_docs_m');
		$doc = $this->clients_docs_m->get_custom_one($id);
		if(empty($doc)){show_404();}
		$data = array();
		$data['box_icon'] = "fa fa-file-o";
		$data['box_title'] =lang('document')." ".$doc['name'];
		$data['box_content'] = $this->load->view('clients_repo/doc', $doc, TRUE);
		$data['box_top_buttons'] = anchor('clients_docs/edit/'.$client_id.'/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm" target="#clients_repo_tree_content"');
		$data['box_top_buttons'].= "&nbsp;";
		$data['box_top_buttons'].= anchor('clients_docs/delete/'.$client_id.'/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm" target="#clients_repo_tree_content"');
		return $data;
	}

	public function order()
	{
		$nodes			= $this->input->post('nodes');
		$children		= $this->_orderChildren($nodes['children']);
	}

	private function _orderChildren($children)
	{
		foreach($children as $key => $value)
		{
			switch(substr($value['id'], 0, 2))
			{
				case 'c_':
					$this->db->where('id', substr($value['id'], 2))
						->update('clients_categories', array(
							'order'		=> (int)$key + 1
						));

					if(isset($value['children']) && (count($value['children']) > 0))
					{
						$this->_orderChildren($value['children']);
					}
					break;
				case 'd_':
					$this->db->where('id', substr($value['id'], 2))
						->update('clients_docs', array(
							'order'		=> (int)$key + 1
						));
					break;
			}
		}
	}
}