<?php 
 /**
  * Controller for Notifications sents
  *
  * This is the controller used to Notifications sents section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  * @ignore
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Notifications_sents - Controller
  *
  * Controller for Notifications sents section.
  */
class Notifications_sents extends MY_Controller {

	/** @var string This is the model associated to the controller. */
	var $model = 'notifications_clients_m';
	/** @var string This is the title for layout view. */
	var $notification_id;

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = lang('menu_notifications');
		$this->main_tip = lang('notifications_tip');
	}

	/**
	  * index
	  *
	  * @param int $notification_id
	  */
	function index($notification_id)
	{
		$this->add_pre_breadcum('notifications', '<i class="fa fa-bullhorn"></i> '. lang('menu_notifications'));
		$name = strtolower(get_class($this));
		$data = array();
		$data['values'] = array('id' => $notification_id);
		$data['table_id'] = $name."_table"; 
		$data['toolbar'] = ''; 
		$data['items_source'] = $name.'/table/'.$notification_id; 
		$data['items_table'] = $this->_get_items('table');
		$data['content_view'] = "crud/table";
		$this->show_template('notifications/edit', $data);
	}

	/**
	  * table
	  *
	  * @param int $notification_id
	  */
	public function table($notification_id)
	{
		$this->notification_id = $notification_id;
		$this->load->view('output/json', array('json' => $this->_ajax_table()));
	}

	/**
	  * This callback runs on each row. It escapes the auto column value and runs the callback.
	  * For this callback the return value is required and must be a string.
	  *
	  * @param string $key Name of column 
	  * @param mixed $value Value 
	  * @param array $row Array containing all row data 
	  *
	  * @return string
	  */
	function _callback_row($key, $value, &$row)
	{
		switch($key)
		{
			case 'id':
				$value				= anchor('clients_repo/index/'.$value,'<i class="fa fa-book"></i> '.lang('docs_nots'), 'class="btn btn-success btn-sm"');
				break;
		}

		return $value === NULL ? '' : $value; 
	}


	/**
	  * _callback_filter
	  */
	function _callback_filter()
	{
		return "notification_id=".$this->notification_id;
	}
}