<?php
 /**
  * Controller for Repo categories
  *
  * This is the controller used to Repo categories.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Repo_categories - Controller
  *
  * Controller for Repo categories section.
  */
class Repo_categories extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'repo_categories_m';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->create_title	= lang('repo_categories_create');
		$this->icon			= 'fa fa-folder-o';
	}

	/**
	  * Return layout view for create section of crud.
	  *
	  * @param int|null $parent_id Parent ID
	  */
	function create($parent_id = NULL)
	{
		$this->repo_categories_m->set_parent_id($parent_id);

		$parent_id			= $parent_id == NULL ? 'root' : 'c_'.$parent_id;

		$this->load->view('crud/create', $this->_create('repo/tree_panel/'.$parent_id, '#repo_tree_content'));
	}

	/**
	  * Return layout view for edit section of crud.
	  *
	  * @param int $id ID
	  */
	function edit($id)
	{
		$back				= 'repo/tree_panel/c_'.$id;

		$this->load->view('crud/edit', $this->_edit($id, $back, '#repo_tree_content'));
	}

	/**
	  * Return layout view for delete section of crud.
	  *
	  * @param int $id ID
	  */
	function delete($id)
	{
		$cat				= $this->repo_categories_m->get_one($id);
		$cat_id				= $cat['parent_id']==NULL ? 'root' : 'c_'.$cat['parent_id'];
		$back				= 'repo/tree_panel/c_'.$id;
		$ok					= 'repo/tree_panel/'.$cat_id;

		$this->load->view('crud/delete', $this->_delete($id, $back, '#repo_tree_content', $ok, FALSE));
	}

}