<?php
 /**
  * Controller for Repo_docs
  *
  * This is the controller used to Repo docs section.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Repo_docs - Controller
  *
  * Controller for Repo docs section.
  */
class Repo_docs extends MY_Controller
{
	/** @var string This is the model associated to the controller. */
	var $model = 'repo_docs_m';

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();

		$this->create_title	= lang('repo_docs_create');
		$this->icon			= 'fa fa-file-o';
	}

	/**
	  * Return layout view for create section of crud.
	  *
	  * @param null|int $parent_id Parent ID
	  */
	function create($parent_id=NULL)
	{
		$this->repo_docs_m->set_category_id($parent_id);

		$parent_id			= $parent_id==NULL ? 'root' : 'c_'.$parent_id;

		$this->load->view('crud/create', $this->_create('repo/tree_panel/'.$parent_id, '#repo_tree_content'));
	}

	/**
	  * Return layout view for edit section of crud.
	  *
	  * @param int $id ID
	  */
	function edit($id)
	{
		$back				= 'repo/tree_panel/'.'d_'.$id;

		$this->load->view('crud/edit', $this->_edit($id, $back, '#repo_tree_content'));
	}

	/**
	  * Return layout view for delete section of crud.
	  *
	  * @param int $id ID
	  */
	function delete($id)
	{
		$doc				= $this->repo_docs_m->get_one($id);
		$cat_id				= $doc['category_id']==NULL ? 'root' : 'c_'.$doc['category_id'];
		$back				= 'repo/tree_panel/d_'.$id;
		$ok					= 'repo/tree_panel/'.$cat_id;

		$this->load->view('crud/delete', $this->_delete($id, $back, '#repo_tree_content', $ok, FALSE));
	}

	/**
	  * Help delete method to return layout view for delete section of crud or to process submit for delete section.
	  *
	  * @param string $id Primary key value
	  * @param string $back Segment url passed to base_url helper used to back when click on cancel button on delete section
	  * @param string $target Segment url passed to base_url helper used to go when click on submit button on delete section
	  * @param string $ok -
	  * @param true|false $wrap -
	  *
	  * @return mixed
	  */
	function _delete($id, $back='', $target='', $ok=NULL, $wrap=TRUE)
	{
		if($ok==NULL)
		{
			$ok					= $back;
		}
		$model				= $this->model;
		$items				= $this->_get_items('delete');

		$this->_set_rules($items);

		$data				= array();
		if($this->form_validation->run() == TRUE)
		{
			$delete_id			= $this->$model->delete($id);
			$data['id']			= $delete_id;
			if($delete_id <= 0)
			{
				$data['msg']		= 'Ha ocurrido un error pongase en contacto con el administrador';
			} else {
				$data['msg']		= 'Borrado correctamente';
			}
		} else {
			$this->load->model('clients_repo_docs_m');

			$checkrepodoc		= $this->clients_repo_docs_m->get_by_repo_doc_id($id);
			if($checkrepodoc > 0)
			{
				$clientsesbid		= $this->clients_repo_docs_m->get_esb_by_repo_doc_id($id);
				$esbidslist			= [];
				foreach($clientsesbid as $value)
				{
					array_push($esbidslist,$value['external_id']);
				}
				$data['esbidslist']		= 'The following users have access to this document: ' . implode(", ",$esbidslist);
				$data['esbidslist']		.= '<br />Are you sure that you want to delete this document? It won\'t be available for end users any more.';

				$this->delete_msg		= "This document is available for at least one user.";
			}

			$data['values']		= $this->$model->get_one($id);
			$data['fields']		= $this->_get_fields($items, $data['values']);
			$data['icon']		= $this->icon;
			$data['back']		= $back;
			$data['wrap']		= $wrap;
			$data['target']		= $target;

			$this->_delete_msg($data);
		}
		if(isset($data['id']))
		{
			redirect($ok);
		} else {
			return $data;
		}
	}
}