<?php 
 /**
  * Controller for Uploader
  *
  * This is the controller used to Uploader.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Uploader - Controller
  *
  * Controller for Uploader.
  */
class Uploader extends MY_Controller {

	/**
	  * Constructor
	  */
	function __construct()
    {
        parent::__construct();
	}
	
	/**
	  * Process an upload
	  *
	  */
	function index()
	{
		
		$this->load->library('upload', [
			'upload_path'		=> TEMP_UPLOAD,
			'allowed_types'		=> 'jpg|jpeg|gif|png|pdf|doc|docx',
			'encrypt_name'		=> TRUE,
			'remove_spaces'		=> TRUE,
			'overwrite'			=> FALSE
		]);

		if($this->upload->do_upload('Filedata'))
		{
			$data				= $this->upload->data();

			echo $data['file_name'];
		} else {
			echo $this->upload->display_errors('<p>', '</p>');
		}
	}

	/**
	  * Show uploaded file
	  *
	  * @param null|string $dir Directory
	  * @param null|string $file Filename
	  */
	function view($dir=NULL, $file=NULL)
	{
		$this->load->helper('file');

		$content			= read_file(BASE_UPLOAD.$dir.'/'.$file);
		if($content != FALSE)
		{
			$this->output->set_content_type(get_mime_by_extension($file));
			$this->output->set_output($content);
		} else {
			show_404();
		}
	}
}