<?php
 /**
  * Migration
  *
  * This is the migration used to admin table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_admin_table - Migration
  *
  * Migration for admin table.
  */
class Migration_Create_admin_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database
	  */
	public function up()
	{
		if(!$this->db->table_exists('admin'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'INT',
					'constraint' => 10,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'user' => array(
					'type' => 'VARCHAR',
					'constraint' => '20',
					'null' => FALSE,
				),
				'password' => array(
					'type' => 'VARCHAR',
					'constraint' => '128',
					'null' => FALSE,
				),
				'fullname' => array(
					'type' => 'VARCHAR',
					'constraint' => '50',
					'null' => FALSE,
				),
				'role' => array(
					'type' => 'VARCHAR',
					'constraint' => '255',
					'null' => FALSE,
				),
				'image' => array(
					'type' => 'VARCHAR',
					'constraint' => '200',
					'null' => FALSE,
				),
				'url' => array(
					'type' => 'VARCHAR',
					'constraint' => '75',
					'null' => FALSE,
				),
				'email' => array(
					'type' => 'VARCHAR',
					'constraint' => '100',
					'null' => FALSE,
				),
				'telephone' => array(
					'type' => 'VARCHAR',
					'constraint' => '20',
					'null' => FALSE,
				),
				'schedule' => array(
					'type' => 'VARCHAR',
					'constraint' => '255',
					'null' => FALSE,
				),
				'company' => array(
					'type' => 'VARCHAR',
					'constraint' => '60',
					'null' => FALSE,
				),
				'address' => array(
					'type' => 'VARCHAR',
					'constraint' => '120',
					'null' => FALSE,
				),
				'zip' => array(
					'type' => 'VARCHAR',
					'constraint' => '7',
					'null' => FALSE,
				),
				'city' => array(
					'type' => 'VARCHAR',
					'constraint' => '35',
					'null' => FALSE,
				),
				'main_manager' => array(
					'type' => 'TINYINT',
					'constraint' => '1',
					'null' => FALSE,
				),
				'user_role' => array(
					'type' => 'TINYINT',
					'constraint' => '4',
					'default' => '1',
					'null' => TRUE,
				),
				'business_partner' => array(
					'type' => 'VARCHAR',
					'constraint' => '450',
					'default' => NULL,
					'null' => TRUE,
				)
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('admin');
			$this->db->query('ALTER TABLE admin ADD UNIQUE INDEX admin (user)');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method
	  */
	public function down()
	{
		if($this->db->table_exists('admin'))
			$this->dbforge->drop_table('admin');
	}
}