<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_docs_assignment_repo_docs_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('docs_assignment_repo_docs'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'INT',
					'constraint' => 11,
					'auto_increment' => TRUE,
				),
				'`docs_assignment_id` int(11) DEFAULT NULL',
				'`repo_doc_id` int(11) DEFAULT NULL',
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('docs_assignment_repo_docs');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down() 
	{
		if($this->db->table_exists('docs_assignment_repo_docs'))
			$this->dbforge->drop_table('docs_assignment_repo_docs');
	}
}